/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source;

import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.mongodb.source.MongoDBSource;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfigFactory;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@Experimental
@PublicEvolving
public class MongoDBSourceBuilder<T> {
    private final MongoDBSourceConfigFactory configFactory = new MongoDBSourceConfigFactory();
    private DebeziumDeserializationSchema<T> deserializer;

    public MongoDBSourceBuilder<T> scheme(String scheme) {
        this.configFactory.scheme(scheme);
        return this;
    }

    public MongoDBSourceBuilder<T> hosts(String hosts) {
        this.configFactory.hosts(hosts);
        return this;
    }

    public MongoDBSourceBuilder<T> connectionOptions(String connectionOptions) {
        this.configFactory.connectionOptions(connectionOptions);
        return this;
    }

    public MongoDBSourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public MongoDBSourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public MongoDBSourceBuilder<T> databaseList(String ... databases) {
        this.configFactory.databaseList(databases);
        return this;
    }

    public MongoDBSourceBuilder<T> collectionList(String ... collections) {
        this.configFactory.collectionList(collections);
        return this;
    }

    public MongoDBSourceBuilder<T> batchSize(int batchSize) {
        this.configFactory.batchSize(batchSize);
        return this;
    }

    public MongoDBSourceBuilder<T> pollAwaitTimeMillis(int pollAwaitTimeMillis) {
        Preconditions.checkArgument((pollAwaitTimeMillis > 0 ? 1 : 0) != 0);
        this.configFactory.pollAwaitTimeMillis(pollAwaitTimeMillis);
        return this;
    }

    public MongoDBSourceBuilder<T> pollMaxBatchSize(int pollMaxBatchSize) {
        this.configFactory.pollMaxBatchSize(pollMaxBatchSize);
        return this;
    }

    public MongoDBSourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public MongoDBSourceBuilder<T> heartbeatIntervalMillis(int heartbeatIntervalMillis) {
        this.configFactory.heartbeatIntervalMillis(heartbeatIntervalMillis);
        return this;
    }

    public MongoDBSourceBuilder<T> splitSizeMB(int splitSizeMB) {
        this.configFactory.splitSizeMB(splitSizeMB);
        return this;
    }

    public MongoDBSourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public MongoDBSourceBuilder<T> closeIdleReaders(boolean closeIdleReaders) {
        this.configFactory.closeIdleReaders(closeIdleReaders);
        return this;
    }

    public MongoDBSourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public MongoDBSource<T> build() {
        return new MongoDBSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer));
    }
}

