/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.offset;

import io.debezium.relational.TableId;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ChangeStreamDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String database;
    @Nullable
    private final String collection;
    @Nullable
    private final Pattern databaseRegex;
    @Nullable
    private final Pattern namespaceRegex;

    public ChangeStreamDescriptor(@Nullable String database, @Nullable String collection, @Nullable Pattern databaseRegex, @Nullable Pattern namespaceRegex) {
        this.database = database;
        this.collection = collection;
        this.databaseRegex = databaseRegex;
        this.namespaceRegex = namespaceRegex;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getCollection() {
        return this.collection;
    }

    @Nullable
    public Pattern getDatabaseRegex() {
        return this.databaseRegex;
    }

    @Nullable
    public Pattern getNamespaceRegex() {
        return this.namespaceRegex;
    }

    public static ChangeStreamDescriptor collection(TableId collectionId) {
        return ChangeStreamDescriptor.collection(collectionId.catalog(), collectionId.table());
    }

    public static ChangeStreamDescriptor collection(String database, String collection) {
        return new ChangeStreamDescriptor(database, collection, null, null);
    }

    public static ChangeStreamDescriptor database(String database) {
        return new ChangeStreamDescriptor(database, null, null, null);
    }

    public static ChangeStreamDescriptor database(String database, Pattern namespaceRegex) {
        return new ChangeStreamDescriptor(database, null, null, namespaceRegex);
    }

    public static ChangeStreamDescriptor deployment(Pattern databaseRegex) {
        return new ChangeStreamDescriptor(null, null, databaseRegex, null);
    }

    public static ChangeStreamDescriptor deployment(@Nullable Pattern databaseRegex, Pattern namespaceRegex) {
        return new ChangeStreamDescriptor(null, null, databaseRegex, namespaceRegex);
    }

    public static ChangeStreamDescriptor deployment() {
        return new ChangeStreamDescriptor(null, null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeStreamDescriptor that = (ChangeStreamDescriptor)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection) && Objects.equals(this.databaseRegex, that.databaseRegex) && Objects.equals(this.namespaceRegex, that.namespaceRegex);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.collection, this.databaseRegex, this.namespaceRegex);
    }

    public String toString() {
        return "ChangeStreamDescriptor{database='" + this.database + '\'' + ", collection='" + this.collection + '\'' + ", databaseRegex=" + this.databaseRegex + ", namespaceRegex=" + this.namespaceRegex + '}';
    }
}

