/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.utils;

import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class CollectionDiscoveryUtils {
    public static final String REGEX_META_CHARACTERS = ".$|()[]{}<>^?*+=!\\";
    public static final String ADD_NS_FIELD_NAME = "_ns_";
    public static final Bson ADD_NS_FIELD = BsonDocument.parse((String)String.format("{'$addFields': {'%s': {'$concat': ['$ns.db', '.', '$ns.coll']}}}", "_ns_"));
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\[(([a-z]-[a-z])|([A-Z]-[A-Z])|((0|[1-9][0-9]*)-(0|[1-9][0-9]*)))+\\]");

    private CollectionDiscoveryUtils() {
    }

    public static List<String> databaseNames(MongoClient mongoClient, Predicate<String> databaseFilter) {
        ArrayList<String> databaseNames = new ArrayList<String>();
        mongoClient.listDatabaseNames().forEach(dbName -> {
            if (databaseFilter.test((String)dbName)) {
                databaseNames.add((String)dbName);
            }
        });
        return databaseNames;
    }

    public static List<String> collectionNames(MongoClient mongoClient, List<String> databaseNames, Predicate<String> collectionFilter) {
        return CollectionDiscoveryUtils.collectionNames(mongoClient, databaseNames, collectionFilter, String::toString);
    }

    public static <T> List<T> collectionNames(MongoClient mongoClient, List<String> databaseNames, Predicate<String> collectionFilter, Function<String, T> conversion) {
        ArrayList collectionNames = new ArrayList();
        for (String dbName : databaseNames) {
            MongoDatabase db = mongoClient.getDatabase(dbName);
            db.listCollectionNames().map(collName -> dbName + "." + collName).forEach(fullName -> {
                if (collectionFilter.test((String)fullName)) {
                    collectionNames.add(conversion.apply((String)fullName));
                }
            });
        }
        return collectionNames;
    }

    private static Predicate<String> stringListFilter(Predicate<String> filter, List<String> stringList) {
        if (CollectionUtils.isNotEmpty(stringList)) {
            List<Pattern> databasePatterns = CollectionDiscoveryUtils.includeListAsPatterns(stringList);
            filter = filter.and(CollectionDiscoveryUtils.anyMatch(databasePatterns));
        }
        return filter;
    }

    public static Predicate<String> databaseFilter(List<String> databaseList) {
        return CollectionDiscoveryUtils.stringListFilter(CollectionDiscoveryUtils::isNotBuiltInDatabase, databaseList);
    }

    public static Predicate<String> collectionsFilter(List<String> collectionList) {
        return CollectionDiscoveryUtils.stringListFilter(CollectionDiscoveryUtils::isNotBuiltInCollections, collectionList);
    }

    public static Predicate<String> anyMatch(List<Pattern> patterns) {
        return s -> {
            for (Pattern p : patterns) {
                if (!p.matcher((CharSequence)s).matches()) continue;
                return true;
            }
            return false;
        };
    }

    public static Pattern includeListAsFlatPattern(List<String> includeList) {
        return CollectionDiscoveryUtils.includeListAsFlatPattern(includeList, CollectionDiscoveryUtils::completionPattern);
    }

    public static Pattern includeListAsFlatPattern(List<String> includeList, Function<String, Pattern> conversion) {
        if (includeList == null || includeList.isEmpty()) {
            return null;
        }
        String flatPatternLiteral = CollectionDiscoveryUtils.includeListAsPatterns(includeList, conversion).stream().map(Pattern::pattern).collect(Collectors.joining("|"));
        return Pattern.compile(flatPatternLiteral);
    }

    public static List<Pattern> includeListAsPatterns(List<String> includeList) {
        return CollectionDiscoveryUtils.includeListAsPatterns(includeList, CollectionDiscoveryUtils::completionPattern);
    }

    public static List<Pattern> includeListAsPatterns(List<String> includeList, Function<String, Pattern> convertion) {
        if (includeList != null && !includeList.isEmpty()) {
            return includeList.stream().map(convertion).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean isIncludeListExplicitlySpecified(List<String> includeList, List<String> discoveredList) {
        if (includeList == null || includeList.size() != 1) {
            return false;
        }
        if (discoveredList == null || discoveredList.size() != 1) {
            return false;
        }
        String firstOfIncludeList = includeList.get(0);
        String firstOfDiscoveredList = discoveredList.get(0);
        return firstOfDiscoveredList.equals(firstOfIncludeList);
    }

    public static boolean isNotBuiltInCollections(String fullName) {
        if (fullName == null) {
            return false;
        }
        MongoNamespace namespace = new MongoNamespace(fullName);
        return CollectionDiscoveryUtils.isNotBuiltInDatabase(namespace.getDatabaseName()) && !namespace.getCollectionName().startsWith("system.");
    }

    public static boolean isNotBuiltInDatabase(String databaseName) {
        if (databaseName == null) {
            return false;
        }
        return !"local".equals(databaseName) && !"admin".equals(databaseName) && !"config".equals(databaseName);
    }

    public static boolean containsRegexMetaCharacters(String literal) {
        if (StringUtils.isEmpty((CharSequence)literal)) {
            return false;
        }
        for (int i = 0; i < literal.length(); ++i) {
            if (REGEX_META_CHARACTERS.indexOf(literal.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRegexRange(String literal) {
        return RANGE_PATTERN.matcher(literal).find();
    }

    public static boolean inferIsRegularExpression(String literal) {
        return CollectionDiscoveryUtils.containsRegexMetaCharacters(literal) || CollectionDiscoveryUtils.containsRegexRange(literal);
    }

    public static Pattern completionPattern(String pattern) {
        if (pattern.startsWith("^") && pattern.endsWith("$")) {
            return Pattern.compile(pattern);
        }
        return Pattern.compile("^(" + pattern + ")$");
    }

    public static String bsonListToJson(List<Bson> bsonList) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean first = true;
        for (Bson bson : bsonList) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(bson.toBsonDocument().toJson());
        }
        builder.append("]");
        return builder.toString();
    }

    public static class CollectionDiscoveryInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> discoveredDatabases;
        private final List<String> discoveredCollections;

        public CollectionDiscoveryInfo(List<String> discoveredDatabases, List<String> discoveredCollections) {
            this.discoveredDatabases = discoveredDatabases;
            this.discoveredCollections = discoveredCollections;
        }

        public List<String> getDiscoveredDatabases() {
            return this.discoveredDatabases;
        }

        public List<String> getDiscoveredCollections() {
            return this.discoveredCollections;
        }
    }
}

