/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql;

import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Collector;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeekBinlogToTimestampFilter<T>
implements DebeziumDeserializationSchema<T> {
    private static final long serialVersionUID = -4450118969976653497L;
    protected static final Logger LOG = LoggerFactory.getLogger(SeekBinlogToTimestampFilter.class);
    private final long startupTimestampMillis;
    private final DebeziumDeserializationSchema<T> serializer;
    private transient boolean find = false;
    private transient long filtered = 0L;

    public SeekBinlogToTimestampFilter(long startupTimestampMillis, DebeziumDeserializationSchema<T> serializer) {
        this.startupTimestampMillis = startupTimestampMillis;
        this.serializer = serializer;
    }

    public void deserialize(SourceRecord record, Collector<T> out) throws Exception {
        Struct value;
        Struct source;
        Long ts;
        if (this.find) {
            this.serializer.deserialize(record, out);
            return;
        }
        if (this.filtered == 0L) {
            LOG.info("Begin to seek binlog to the specific timestamp {}.", (Object)this.startupTimestampMillis);
        }
        if ((ts = (source = (value = (Struct)record.value()).getStruct("source")).getInt64("ts_ms")) != null && ts >= this.startupTimestampMillis) {
            this.serializer.deserialize(record, out);
            this.find = true;
            LOG.info("Successfully seek to the specific timestamp {} with filtered {} change events.", (Object)this.startupTimestampMillis, (Object)this.filtered);
        } else {
            ++this.filtered;
            if (this.filtered % 10000L == 0L) {
                LOG.info("Seeking binlog to specific timestamp with filtered {} change events.", (Object)this.filtered);
            }
        }
    }

    public TypeInformation<T> getProducedType() {
        return this.serializer.getProducedType();
    }
}

