/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.debezium.reader;

import com.ververica.cdc.connectors.mysql.debezium.dispatcher.SignalEventDispatcher;
import com.ververica.cdc.connectors.mysql.debezium.reader.DebeziumReader;
import com.ververica.cdc.connectors.mysql.debezium.task.MySqlBinlogSplitReadTask;
import com.ververica.cdc.connectors.mysql.debezium.task.MySqlSnapshotSplitReadTask;
import com.ververica.cdc.connectors.mysql.debezium.task.context.StatefulTaskContext;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import com.ververica.cdc.connectors.mysql.source.utils.RecordUtils;
import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.util.SchemaNameAdjuster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotSplitReader
implements DebeziumReader<SourceRecord, MySqlSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotSplitReader.class);
    private final StatefulTaskContext statefulTaskContext;
    private final ExecutorService executor;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile boolean currentTaskRunning;
    private volatile Throwable readException;
    private MySqlSnapshotSplitReadTask splitSnapshotReadTask;
    private MySqlSnapshotSplit currentSnapshotSplit;
    private SchemaNameAdjuster nameAdjuster;
    public AtomicBoolean hasNextElement;
    public AtomicBoolean reachEnd;

    public SnapshotSplitReader(StatefulTaskContext statefulTaskContext, int subtaskId) {
        this.statefulTaskContext = statefulTaskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subtaskId).build();
        this.executor = Executors.newSingleThreadExecutor(threadFactory);
        this.currentTaskRunning = false;
        this.hasNextElement = new AtomicBoolean(false);
        this.reachEnd = new AtomicBoolean(false);
    }

    @Override
    public void submitSplit(MySqlSplit mySqlSplit) {
        this.currentSnapshotSplit = mySqlSplit.asSnapshotSplit();
        this.statefulTaskContext.configure(this.currentSnapshotSplit);
        this.queue = this.statefulTaskContext.getQueue();
        this.nameAdjuster = this.statefulTaskContext.getSchemaNameAdjuster();
        this.hasNextElement.set(true);
        this.reachEnd.set(false);
        this.splitSnapshotReadTask = new MySqlSnapshotSplitReadTask(this.statefulTaskContext.getConnectorConfig(), this.statefulTaskContext.getOffsetContext(), (SnapshotProgressListener)this.statefulTaskContext.getSnapshotChangeEventSourceMetrics(), this.statefulTaskContext.getDatabaseSchema(), this.statefulTaskContext.getConnection(), this.statefulTaskContext.getDispatcher(), this.statefulTaskContext.getTopicSelector(), StatefulTaskContext.getClock(), this.currentSnapshotSplit);
        this.executor.submit(() -> {
            try {
                this.currentTaskRunning = true;
                SnapshotSplitChangeEventSourceContextImpl sourceContext = new SnapshotSplitChangeEventSourceContextImpl();
                SnapshotResult snapshotResult = this.splitSnapshotReadTask.execute(sourceContext);
                MySqlBinlogSplit backfillBinlogSplit = this.createBackfillBinlogSplit(sourceContext);
                boolean binlogBackfillRequired = backfillBinlogSplit.getEndingOffset().isAfter(backfillBinlogSplit.getStartingOffset());
                if (!binlogBackfillRequired) {
                    this.dispatchHighWatermark(backfillBinlogSplit);
                    this.currentTaskRunning = false;
                    return;
                }
                if (snapshotResult.isCompletedOrSkipped()) {
                    MySqlBinlogSplitReadTask backfillBinlogReadTask = this.createBackfillBinlogReadTask(backfillBinlogSplit);
                    backfillBinlogReadTask.execute(new SnapshotBinlogSplitChangeEventSourceContextImpl());
                } else {
                    this.readException = new IllegalStateException(String.format("Read snapshot for mysql split %s fail", this.currentSnapshotSplit));
                }
            }
            catch (Exception e) {
                this.currentTaskRunning = false;
                LOG.error(String.format("Execute snapshot read task for mysql split %s fail", this.currentSnapshotSplit), (Throwable)e);
                this.readException = e;
            }
        });
    }

    private MySqlBinlogSplit createBackfillBinlogSplit(SnapshotSplitChangeEventSourceContextImpl sourceContext) {
        return new MySqlBinlogSplit(this.currentSnapshotSplit.splitId(), sourceContext.getLowWatermark(), sourceContext.getHighWatermark(), new ArrayList<FinishedSnapshotSplitInfo>(), this.currentSnapshotSplit.getTableSchemas(), 0);
    }

    private MySqlBinlogSplitReadTask createBackfillBinlogReadTask(MySqlBinlogSplit backfillBinlogSplit) {
        MySqlOffsetContext.Loader loader = new MySqlOffsetContext.Loader(this.statefulTaskContext.getConnectorConfig());
        MySqlOffsetContext mySqlOffsetContext = (MySqlOffsetContext)loader.load(backfillBinlogSplit.getStartingOffset().getOffset());
        Configuration dezConf = this.statefulTaskContext.getSourceConfig().getDbzConfiguration().edit().with("table.include.list", this.currentSnapshotSplit.getTableId().toString()).build();
        return new MySqlBinlogSplitReadTask(new MySqlConnectorConfig(dezConf), mySqlOffsetContext, this.statefulTaskContext.getConnection(), this.statefulTaskContext.getDispatcher(), this.statefulTaskContext.getErrorHandler(), StatefulTaskContext.getClock(), this.statefulTaskContext.getTaskContext(), (MySqlStreamingChangeEventSourceMetrics)this.statefulTaskContext.getStreamingChangeEventSourceMetrics(), this.statefulTaskContext.getTopicSelector().getPrimaryTopic(), backfillBinlogSplit);
    }

    private void dispatchHighWatermark(MySqlBinlogSplit backFillBinlogSplit) throws InterruptedException {
        SignalEventDispatcher signalEventDispatcher = new SignalEventDispatcher(this.statefulTaskContext.getOffsetContext().getPartition(), this.statefulTaskContext.getTopicSelector().getPrimaryTopic(), this.statefulTaskContext.getDispatcher().getQueue());
        signalEventDispatcher.dispatchWatermarkEvent(backFillBinlogSplit, backFillBinlogSplit.getEndingOffset(), SignalEventDispatcher.WatermarkKind.BINLOG_END);
    }

    @Override
    public boolean isFinished() {
        return this.currentSnapshotSplit == null || !this.currentTaskRunning && !this.hasNextElement.get() && this.reachEnd.get();
    }

    @Override
    @Nullable
    public Iterator<SourceRecord> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        if (this.hasNextElement.get()) {
            boolean reachBinlogEnd = false;
            ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
            block0: while (!reachBinlogEnd) {
                List batch = this.queue.poll();
                for (DataChangeEvent event : batch) {
                    sourceRecords.add(event.getRecord());
                    if (!RecordUtils.isEndWatermarkEvent(event.getRecord())) continue;
                    reachBinlogEnd = true;
                    continue block0;
                }
            }
            this.hasNextElement.set(false);
            return RecordUtils.normalizedSplitRecords(this.currentSnapshotSplit, sourceRecords, this.nameAdjuster).iterator();
        }
        this.reachEnd.compareAndSet(false, true);
        return null;
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new FlinkRuntimeException(String.format("Read split %s error due to %s.", this.currentSnapshotSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.statefulTaskContext.getConnection() != null) {
                this.statefulTaskContext.getConnection().close();
            }
            if (this.statefulTaskContext.getBinaryLogClient() != null) {
                this.statefulTaskContext.getBinaryLogClient().disconnect();
            }
        }
        catch (Exception e) {
            LOG.error("Close snapshot reader error", (Throwable)e);
        }
    }

    public class SnapshotBinlogSplitChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        public void finished() {
            SnapshotSplitReader.this.currentTaskRunning = false;
        }

        public boolean isRunning() {
            return SnapshotSplitReader.this.currentTaskRunning;
        }
    }

    public class SnapshotSplitChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        private BinlogOffset lowWatermark;
        private BinlogOffset highWatermark;

        public BinlogOffset getLowWatermark() {
            return this.lowWatermark;
        }

        public void setLowWatermark(BinlogOffset lowWatermark) {
            this.lowWatermark = lowWatermark;
        }

        public BinlogOffset getHighWatermark() {
            return this.highWatermark;
        }

        public void setHighWatermark(BinlogOffset highWatermark) {
            this.highWatermark = highWatermark;
        }

        public boolean isRunning() {
            return this.lowWatermark != null && this.highWatermark != null;
        }
    }
}

