/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.RowsQueryEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializationException;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.network.AuthenticationException;
import com.github.shyiko.mysql.binlog.network.DefaultSSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.ServerException;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.EventBuffer;
import io.debezium.connector.mysql.EventDataDeserializationExceptionData;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlChangeRecordEmitter;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.RowDeserializers;
import io.debezium.connector.mysql.StopEventDataDeserializer;
import io.debezium.data.Envelope;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MySqlStreamingChangeEventSource
implements StreamingChangeEventSource<MySqlOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlStreamingChangeEventSource.class);
    private static final String KEEPALIVE_THREAD_NAME = "blc-keepalive";
    private final EnumMap<EventType, BlockingConsumer<Event>> eventHandlers = new EnumMap(EventType.class);
    private final BinaryLogClient client;
    private final MySqlStreamingChangeEventSourceMetrics metrics;
    private final Clock clock;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode eventDeserializationFailureHandlingMode;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaHandlingMode;
    private int startingRowNumber = 0;
    private long initialEventsToSkip = 0L;
    private boolean skipEvent = false;
    private boolean ignoreDmlEventByGtidSource = false;
    private final Predicate<String> gtidDmlSourceFilter;
    private final AtomicLong totalRecordCounter = new AtomicLong();
    private volatile Map<String, ?> lastOffset = null;
    private com.github.shyiko.mysql.binlog.GtidSet gtidSet;
    private final float heartbeatIntervalFactor = 0.8f;
    private final Map<String, Thread> binaryLogClientThreads = new ConcurrentHashMap<String, Thread>(4);
    private final MySqlTaskContext taskContext;
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlConnection connection;
    private final EventDispatcher<TableId> eventDispatcher;
    private final ErrorHandler errorHandler;
    private Instant eventTimestamp;

    public MySqlStreamingChangeEventSource(MySqlConnectorConfig connectorConfig, MySqlConnection connection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, MySqlTaskContext taskContext, MySqlStreamingChangeEventSourceMetrics metrics) {
        SSLSocketFactory sslSocketFactory;
        this.taskContext = taskContext;
        this.connectorConfig = connectorConfig;
        this.connection = connection;
        this.clock = clock;
        this.eventDispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.metrics = metrics;
        this.eventDeserializationFailureHandlingMode = connectorConfig.getEventProcessingFailureHandlingMode();
        this.inconsistentSchemaHandlingMode = connectorConfig.inconsistentSchemaFailureHandlingMode();
        this.client = taskContext.getBinaryLogClient();
        this.client.setThreadFactory(Threads.threadFactory(MySqlConnector.class, (String)connectorConfig.getLogicalName(), (String)"binlog-client", (boolean)false, (boolean)false, x -> this.binaryLogClientThreads.put(x.getName(), (Thread)x)));
        this.client.setServerId(connectorConfig.serverId());
        this.client.setSSLMode(this.sslModeFor(connectorConfig.sslMode()));
        if (connectorConfig.sslModeEnabled() && (sslSocketFactory = this.getBinlogSslSocketFactory(connectorConfig, connection)) != null) {
            this.client.setSslSocketFactory(sslSocketFactory);
        }
        Configuration configuration = connectorConfig.getConfig();
        this.client.setKeepAlive(configuration.getBoolean(MySqlConnectorConfig.KEEP_ALIVE));
        long keepAliveInterval = configuration.getLong(MySqlConnectorConfig.KEEP_ALIVE_INTERVAL_MS);
        this.client.setKeepAliveInterval(keepAliveInterval);
        this.client.setHeartbeatInterval((long)((float)keepAliveInterval * 0.8f));
        boolean filterDmlEventsByGtidSource = configuration.getBoolean(MySqlConnectorConfig.GTID_SOURCE_FILTER_DML_EVENTS);
        this.gtidDmlSourceFilter = filterDmlEventsByGtidSource ? connectorConfig.gtidSourceFilter() : null;
        final HashMap tableMapEventByTableId = new HashMap();
        EventDeserializer eventDeserializer = new EventDeserializer(){

            public Event nextEvent(ByteArrayInputStream inputStream) throws IOException {
                try {
                    Event event = super.nextEvent(inputStream);
                    if (event.getHeader().getEventType() == EventType.TABLE_MAP) {
                        TableMapEventData tableMapEvent = (TableMapEventData)event.getData();
                        tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                    }
                    if (event.getHeader().getEventType() == EventType.ROTATE) {
                        tableMapEventByTableId.clear();
                    }
                    return event;
                }
                catch (EventDataDeserializationException edde) {
                    if (edde.getCause() instanceof IOException) {
                        throw edde;
                    }
                    EventHeaderV4 header = new EventHeaderV4();
                    header.setEventType(EventType.INCIDENT);
                    header.setTimestamp(edde.getEventHeader().getTimestamp());
                    header.setServerId(edde.getEventHeader().getServerId());
                    if (edde.getEventHeader() instanceof EventHeaderV4) {
                        header.setEventLength(((EventHeaderV4)edde.getEventHeader()).getEventLength());
                        header.setNextPosition(((EventHeaderV4)edde.getEventHeader()).getNextPosition());
                        header.setFlags(((EventHeaderV4)edde.getEventHeader()).getFlags());
                    }
                    EventDataDeserializationExceptionData data = new EventDataDeserializationExceptionData(edde);
                    return new Event((EventHeader)header, (EventData)data);
                }
            }
        };
        eventDeserializer.setEventDataDeserializer(EventType.STOP, (EventDataDeserializer)new StopEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.GTID, (EventDataDeserializer)new GtidEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        this.client.setEventDeserializer(eventDeserializer);
    }

    protected void onEvent(MySqlOffsetContext offsetContext, Event event) {
        long ts = 0L;
        if (event.getHeader().getEventType() == EventType.HEARTBEAT) {
            this.metrics.setMilliSecondsBehindSource(ts);
            return;
        }
        long eventTs = event.getHeader().getTimestamp();
        if (eventTs == 0L) {
            LOGGER.trace("Received unexpected event with 0 timestamp: {}", (Object)event);
            return;
        }
        ts = this.clock.currentTimeInMillis() - eventTs;
        LOGGER.trace("Current milliseconds behind source: {} ms", (Object)ts);
        this.metrics.setMilliSecondsBehindSource(ts);
    }

    protected void ignoreEvent(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.trace("Ignoring event due to missing handler: {}", (Object)event);
    }

    protected void handleEvent(MySqlOffsetContext offsetContext, Event event) {
        if (event == null) {
            return;
        }
        EventHeader eventHeader = event.getHeader();
        this.eventTimestamp = !eventHeader.getEventType().equals((Object)EventType.HEARTBEAT) ? Instant.ofEpochMilli(eventHeader.getTimestamp()) : null;
        offsetContext.setBinlogThread(eventHeader.getServerId());
        EventType eventType = eventHeader.getEventType();
        if (eventType == EventType.ROTATE) {
            EventData eventData = event.getData();
            RotateEventData rotateEventData = eventData instanceof EventDeserializer.EventDataWrapper ? (RotateEventData)((EventDeserializer.EventDataWrapper)eventData).getInternal() : (RotateEventData)eventData;
            offsetContext.setBinlogStartPoint(rotateEventData.getBinlogFilename(), rotateEventData.getBinlogPosition());
        } else if (eventHeader instanceof EventHeaderV4) {
            EventHeaderV4 trackableEventHeader = (EventHeaderV4)eventHeader;
            offsetContext.setEventPosition(trackableEventHeader.getPosition(), trackableEventHeader.getEventLength());
        }
        try {
            this.eventHandlers.getOrDefault(eventType, (BlockingConsumer<Event>)((BlockingConsumer)e -> this.ignoreEvent(offsetContext, (Event)e))).accept((Object)event);
            this.eventDispatcher.dispatchHeartbeatEvent((OffsetContext)offsetContext);
            offsetContext.completeEvent();
            if (this.skipEvent) {
                --this.initialEventsToSkip;
                this.skipEvent = this.initialEventsToSkip > 0L;
            }
        }
        catch (RuntimeException e2) {
            this.logStreamingSourceState();
            this.errorHandler.setProducerThrowable((Throwable)new DebeziumException("Error processing binlog event", (Throwable)e2));
            this.eventHandlers.clear();
            LOGGER.info("Error processing binlog event, and propagating to Kafka Connect so it stops this connector. Future binlog events read before connector is shutdown will be ignored.");
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            this.eventHandlers.clear();
            LOGGER.info("Stopped processing binlog events due to thread interruption");
        }
    }

    protected <T extends EventData> T unwrapData(Event event) {
        EventData eventData = event.getData();
        if (eventData instanceof EventDeserializer.EventDataWrapper) {
            eventData = ((EventDeserializer.EventDataWrapper)eventData).getInternal();
        }
        return (T)eventData;
    }

    protected void handleServerStop(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.debug("Server stopped: {}", (Object)event);
    }

    protected void handleServerHeartbeat(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.trace("Server heartbeat: {}", (Object)event);
    }

    protected void handleServerIncident(MySqlOffsetContext offsetContext, Event event) {
        if (event.getData() instanceof EventDataDeserializationExceptionData) {
            this.metrics.onErroneousEvent("source = " + event.toString());
            EventDataDeserializationExceptionData data = (EventDataDeserializationExceptionData)event.getData();
            EventHeaderV4 eventHeader = (EventHeaderV4)data.getCause().getEventHeader();
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.error("Error while deserializing binlog event at offset {}.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{offsetContext.getOffset(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
                throw new RuntimeException(data.getCause());
            }
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("Error while deserializing binlog event at offset {}.{}This exception will be ignored and the event be skipped.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{offsetContext.getOffset(), System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename(), data.getCause()});
            }
        } else {
            LOGGER.error("Server incident: {}", (Object)event);
        }
    }

    protected void handleRotateLogsEvent(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.debug("Rotating logs: {}", (Object)event);
        RotateEventData command = (RotateEventData)this.unwrapData(event);
        assert (command != null);
        this.taskContext.getSchema().clearTableMappings();
    }

    protected void handleGtidEvent(MySqlOffsetContext offsetContext, Event event) {
        String uuid;
        LOGGER.debug("GTID transaction: {}", (Object)event);
        GtidEventData gtidEvent = (GtidEventData)this.unwrapData(event);
        String gtid = gtidEvent.getGtid();
        this.gtidSet.add(gtid);
        offsetContext.startGtid(gtid, this.gtidSet.toString());
        this.ignoreDmlEventByGtidSource = false;
        if (this.gtidDmlSourceFilter != null && gtid != null && !this.gtidDmlSourceFilter.test(uuid = gtid.trim().substring(0, gtid.indexOf(":")))) {
            this.ignoreDmlEventByGtidSource = true;
        }
        this.metrics.onGtidChange(gtid);
    }

    protected void handleRowsQuery(MySqlOffsetContext offsetContext, Event event) {
        RowsQueryEventData lastRowsQueryEventData = (RowsQueryEventData)this.unwrapData(event);
        offsetContext.setQuery(lastRowsQueryEventData.getQuery());
    }

    protected void handleQueryEvent(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        QueryEventData command = (QueryEventData)this.unwrapData(event);
        LOGGER.debug("Received query command: {}", (Object)event);
        String sql = command.getSql().trim();
        if (sql.equalsIgnoreCase("BEGIN")) {
            offsetContext.startNextTransaction();
            this.eventDispatcher.dispatchTransactionStartedEvent(offsetContext.getTransactionId(), (OffsetContext)offsetContext);
            offsetContext.setBinlogThread(command.getThreadId());
            if (this.initialEventsToSkip != 0L) {
                LOGGER.debug("Restarting partially-processed transaction; change events will not be created for the first {} events plus {} more rows in the next event", (Object)this.initialEventsToSkip, (Object)this.startingRowNumber);
                this.skipEvent = true;
            }
            return;
        }
        if (sql.equalsIgnoreCase("COMMIT")) {
            this.handleTransactionCompletion(offsetContext, event);
            return;
        }
        String upperCasedStatementBegin = Strings.getBegin((String)sql, (int)7).toUpperCase();
        if (upperCasedStatementBegin.startsWith("XA ")) {
            return;
        }
        if (this.connectorConfig.getDdlFilter().test(sql)) {
            LOGGER.debug("DDL '{}' was filtered out of processing", (Object)sql);
            return;
        }
        if (upperCasedStatementBegin.equals("INSERT ") || upperCasedStatementBegin.equals("UPDATE ") || upperCasedStatementBegin.equals("DELETE ")) {
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                throw new DebeziumException("Received DML '" + sql + "' for processing, binlog probably contains events generated with statement or mixed based replication format");
            }
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("Warning only: Received DML '" + sql + "' for processing, binlog probably contains events generated with statement or mixed based replication format");
                return;
            }
            return;
        }
        if (sql.equalsIgnoreCase("ROLLBACK")) {
            LOGGER.warn("Rollback statements cannot be handled without binlog buffering, the connector will fail. Please check '{}' to see how to enable buffering", (Object)MySqlConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER.name());
        }
        List schemaChangeEvents = this.taskContext.getSchema().parseStreamingDdl(sql, command.getDatabase(), offsetContext, this.clock.currentTimeAsInstant());
        try {
            for (SchemaChangeEvent schemaChangeEvent : schemaChangeEvents) {
                if (this.taskContext.getSchema().skipSchemaChangeEvent(schemaChangeEvent)) continue;
                TableId tableId = schemaChangeEvent.getTables().isEmpty() ? null : ((Table)schemaChangeEvent.getTables().iterator().next()).id();
                this.eventDispatcher.dispatchSchemaChangeEvent((DataCollectionId)tableId, receiver -> {
                    try {
                        receiver.schemaChangeEvent(schemaChangeEvent);
                    }
                    catch (Exception e) {
                        throw new DebeziumException((Throwable)e);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("Processing interrupted");
        }
    }

    private void handleTransactionCompletion(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.eventDispatcher.dispatchTransactionCommittedEvent((OffsetContext)offsetContext);
        offsetContext.commitTransaction();
        offsetContext.setBinlogThread(-1L);
        this.skipEvent = false;
        this.ignoreDmlEventByGtidSource = false;
    }

    protected void handleUpdateTableMetadata(MySqlOffsetContext offsetContext, Event event) {
        TableMapEventData metadata = (TableMapEventData)this.unwrapData(event);
        long tableNumber = metadata.getTableId();
        String databaseName = metadata.getDatabase();
        String tableName = metadata.getTable();
        TableId tableId = new TableId(databaseName, null, tableName);
        if (this.taskContext.getSchema().assignTableNumber(tableNumber, tableId)) {
            LOGGER.debug("Received update table metadata event: {}", (Object)event);
        } else {
            this.informAboutUnknownTableIfRequired(offsetContext, event, tableId, "update table metadata");
        }
    }

    private void informAboutUnknownTableIfRequired(MySqlOffsetContext offsetContext, Event event, TableId tableId, String typeToLog) {
        if (tableId != null && this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
            this.metrics.onErroneousEvent("source = " + tableId + ", event " + event);
            EventHeaderV4 eventHeader = (EventHeaderV4)event.getHeader();
            if (this.inconsistentSchemaHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.error("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database history topic. Take a new snapshot in this case.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, offsetContext.getOffset(), tableId, System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
                throw new DebeziumException("Encountered change event for table " + tableId + " whose schema isn't known to this connector");
            }
            if (this.inconsistentSchemaHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database history topic. Take a new snapshot in this case.{}The event will be ignored.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, offsetContext.getOffset(), tableId, System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
            } else {
                LOGGER.debug("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database history topic. Take a new snapshot in this case.{}The event will be ignored.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, offsetContext.getOffset(), tableId, System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
            }
        } else {
            LOGGER.debug("Filtering {} event: {} for non-monitored table {}", new Object[]{typeToLog, event, tableId});
            this.metrics.onFilteredEvent("source = " + tableId);
        }
    }

    protected void handleInsert(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.handleChange(offsetContext, event, "insert", WriteRowsEventData.class, x -> this.taskContext.getSchema().getTableId(x.getTableId()), WriteRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new MySqlChangeRecordEmitter((OffsetContext)offsetContext, this.clock, Envelope.Operation.CREATE, null, row)));
    }

    protected void handleUpdate(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.handleChange(offsetContext, event, "update", UpdateRowsEventData.class, x -> this.taskContext.getSchema().getTableId(x.getTableId()), UpdateRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new MySqlChangeRecordEmitter((OffsetContext)offsetContext, this.clock, Envelope.Operation.UPDATE, (Serializable[])row.getKey(), (Serializable[])row.getValue())));
    }

    protected void handleDelete(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.handleChange(offsetContext, event, "delete", DeleteRowsEventData.class, x -> this.taskContext.getSchema().getTableId(x.getTableId()), DeleteRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new MySqlChangeRecordEmitter((OffsetContext)offsetContext, this.clock, Envelope.Operation.DELETE, row, null)));
    }

    private <T extends EventData, U> void handleChange(MySqlOffsetContext offsetContext, Event event, String changeType, Class<T> eventDataClass, TableIdProvider<T> tableIdProvider, RowsProvider<T, U> rowsProvider, BinlogChangeEmitter<U> changeEmitter) throws InterruptedException {
        if (this.skipEvent) {
            LOGGER.info("Skipping previously processed row event: {}", (Object)event);
            return;
        }
        if (this.ignoreDmlEventByGtidSource) {
            LOGGER.debug("Skipping DML event because this GTID source is filtered: {}", (Object)event);
            return;
        }
        T data = this.unwrapData(event);
        TableId tableId = tableIdProvider.getTableId(data);
        List<U> rows = rowsProvider.getRows(data);
        if (tableId != null && this.taskContext.getSchema().schemaFor(tableId) != null) {
            int count = 0;
            int numRows = rows.size();
            if (this.startingRowNumber < numRows) {
                for (int row = this.startingRowNumber; row != numRows; ++row) {
                    offsetContext.setRowNumber(row, numRows);
                    offsetContext.event((DataCollectionId)tableId, this.eventTimestamp);
                    changeEmitter.emit(tableId, rows.get(row));
                    ++count;
                }
                if (LOGGER.isDebugEnabled()) {
                    if (this.startingRowNumber != 0) {
                        LOGGER.debug("Emitted {} {} record(s) for last {} row(s) in event: {}", new Object[]{count, changeType, numRows - this.startingRowNumber, event});
                    } else {
                        LOGGER.debug("Emitted {} {} record(s) for event: {}", new Object[]{count, changeType, event});
                    }
                }
                offsetContext.changeEventCompleted();
            } else {
                LOGGER.debug("Skipping previously processed {} event: {}", (Object)changeType, (Object)event);
            }
        } else {
            this.informAboutUnknownTableIfRequired(offsetContext, event, tableId, changeType + " row");
        }
        this.startingRowNumber = 0;
    }

    protected void viewChange(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        LOGGER.debug("View Change event: {}", (Object)event);
    }

    protected void prepareTransaction(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        LOGGER.debug("XA Prepare event: {}", (Object)event);
    }

    private SSLMode sslModeFor(MySqlConnectorConfig.SecureConnectionMode mode) {
        switch (mode) {
            case DISABLED: {
                return SSLMode.DISABLED;
            }
            case PREFERRED: {
                return SSLMode.PREFERRED;
            }
            case REQUIRED: {
                return SSLMode.REQUIRED;
            }
            case VERIFY_CA: {
                return SSLMode.VERIFY_CA;
            }
            case VERIFY_IDENTITY: {
                return SSLMode.VERIFY_IDENTITY;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, MySqlOffsetContext offsetContext) throws InterruptedException {
        BinaryLogClient.EventListener listener;
        if (!this.connectorConfig.getSnapshotMode().shouldStream()) {
            LOGGER.info("Streaming is disabled for snapshot mode {}", (Object)this.connectorConfig.getSnapshotMode());
            return;
        }
        this.taskContext.getSchema().assureNonEmptySchema();
        EnumSet skippedOperations = this.connectorConfig.getSkippedOperations();
        MySqlOffsetContext effectiveOffsetContext = offsetContext != null ? offsetContext : MySqlOffsetContext.initial((MySqlConnectorConfig)this.connectorConfig);
        this.eventHandlers.put(EventType.STOP, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerStop(effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.HEARTBEAT, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerHeartbeat(effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.INCIDENT, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerIncident(effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.ROTATE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleRotateLogsEvent(effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.TABLE_MAP, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdateTableMetadata(effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.QUERY, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleQueryEvent(effectiveOffsetContext, (Event)event)));
        if (!skippedOperations.contains(Envelope.Operation.CREATE)) {
            this.eventHandlers.put(EventType.WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleInsert(effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleInsert(effectiveOffsetContext, (Event)event)));
        }
        if (!skippedOperations.contains(Envelope.Operation.UPDATE)) {
            this.eventHandlers.put(EventType.UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdate(effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdate(effectiveOffsetContext, (Event)event)));
        }
        if (!skippedOperations.contains(Envelope.Operation.DELETE)) {
            this.eventHandlers.put(EventType.DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleDelete(effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleDelete(effectiveOffsetContext, (Event)event)));
        }
        this.eventHandlers.put(EventType.VIEW_CHANGE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.viewChange(effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.XA_PREPARE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.prepareTransaction(effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.XID, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleTransactionCompletion(effectiveOffsetContext, (Event)event)));
        if (this.connectorConfig.includeSqlQuery()) {
            this.eventHandlers.put(EventType.ROWS_QUERY, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleRowsQuery(effectiveOffsetContext, (Event)event)));
        }
        if (this.connectorConfig.bufferSizeForStreamingChangeEventSource() == 0) {
            listener = event -> this.handleEvent(effectiveOffsetContext, event);
        } else {
            EventBuffer buffer = new EventBuffer(this.connectorConfig.bufferSizeForStreamingChangeEventSource(), this, context);
            listener = event -> buffer.add(effectiveOffsetContext, event);
        }
        this.client.registerEventListener(listener);
        this.client.registerLifecycleListener((BinaryLogClient.LifecycleListener)new ReaderThreadLifecycleListener(effectiveOffsetContext));
        this.client.registerEventListener(event -> this.onEvent(effectiveOffsetContext, event));
        if (LOGGER.isDebugEnabled()) {
            this.client.registerEventListener(event -> this.logEvent(effectiveOffsetContext, event));
        }
        boolean isGtidModeEnabled = this.connection.isGtidModeEnabled();
        this.metrics.setIsGtidModeEnabled(isGtidModeEnabled);
        String availableServerGtidStr = this.connection.knownGtidSet();
        if (isGtidModeEnabled) {
            this.eventHandlers.put(EventType.GTID, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleGtidEvent(effectiveOffsetContext, (Event)event)));
            GtidSet availableServerGtidSet = new GtidSet(availableServerGtidStr);
            GtidSet purgedServerGtidSet = this.connection.purgedGtidSet();
            LOGGER.info("GTID set purged on server: {}", (Object)purgedServerGtidSet);
            GtidSet filteredGtidSet = this.filterGtidSet(effectiveOffsetContext, availableServerGtidSet, purgedServerGtidSet);
            if (filteredGtidSet != null) {
                LOGGER.info("Registering binlog reader with GTID set: {}", (Object)filteredGtidSet);
                String filteredGtidSetStr = filteredGtidSet.toString();
                this.client.setGtidSet(filteredGtidSetStr);
                effectiveOffsetContext.setCompletedGtidSet(filteredGtidSetStr);
                this.gtidSet = new com.github.shyiko.mysql.binlog.GtidSet(filteredGtidSetStr);
            } else {
                this.client.setBinlogFilename(effectiveOffsetContext.getSource().binlogFilename());
                this.client.setBinlogPosition(effectiveOffsetContext.getSource().binlogPosition());
                this.gtidSet = new com.github.shyiko.mysql.binlog.GtidSet("");
            }
        } else {
            this.client.setBinlogFilename(effectiveOffsetContext.getSource().binlogFilename());
            this.client.setBinlogPosition(effectiveOffsetContext.getSource().binlogPosition());
        }
        this.initialEventsToSkip = effectiveOffsetContext.eventsToSkipUponRestart();
        LOGGER.info("Skip {} events on streaming start", (Object)this.initialEventsToSkip);
        this.startingRowNumber = effectiveOffsetContext.rowsToSkipUponRestart();
        LOGGER.info("Skip {} rows on streaming start", (Object)this.startingRowNumber);
        this.skipEvent = false;
        try {
            if (context.isRunning()) {
                long timeout = this.connectorConfig.getConnectionTimeout().toMillis();
                long started = this.clock.currentTimeInMillis();
                try {
                    LOGGER.debug("Attempting to establish binlog reader connection with timeout of {} ms", (Object)timeout);
                    this.client.connect(timeout);
                    if (this.client.isKeepAlive()) {
                        LOGGER.info("Waiting for keepalive thread to start");
                        Metronome metronome = Metronome.parker((Duration)Duration.ofMillis(100L), (Clock)this.clock);
                        int waitAttempts = 50;
                        boolean keepAliveThreadRunning = false;
                        while (!keepAliveThreadRunning && waitAttempts-- > 0) {
                            for (Thread t : this.binaryLogClientThreads.values()) {
                                if (!t.getName().startsWith(KEEPALIVE_THREAD_NAME) || !t.isAlive()) continue;
                                LOGGER.info("Keepalive thread is running");
                                keepAliveThreadRunning = true;
                            }
                            metronome.pause();
                        }
                    }
                }
                catch (TimeoutException e) {
                    long duration = this.clock.currentTimeInMillis() - started;
                    if ((double)duration > 0.9 * (double)timeout) {
                        double actualSeconds = TimeUnit.MILLISECONDS.toSeconds(duration);
                        throw new DebeziumException("Timed out after " + actualSeconds + " seconds while waiting to connect to MySQL at " + this.connectorConfig.hostname() + ":" + this.connectorConfig.port() + " with user '" + this.connectorConfig.username() + "'", (Throwable)e);
                    }
                }
                catch (AuthenticationException e) {
                    throw new DebeziumException("Failed to authenticate to the MySQL database at " + this.connectorConfig.hostname() + ":" + this.connectorConfig.port() + " with user '" + this.connectorConfig.username() + "'", (Throwable)e);
                }
                catch (Throwable e) {
                    throw new DebeziumException("Unable to connect to the MySQL database at " + this.connectorConfig.hostname() + ":" + this.connectorConfig.port() + " with user '" + this.connectorConfig.username() + "': " + e.getMessage(), e);
                }
            }
            while (context.isRunning()) {
                Thread.sleep(100L);
            }
        }
        finally {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                LOGGER.info("Exception while stopping binary log client", (Throwable)e);
            }
        }
    }

    private SSLSocketFactory getBinlogSslSocketFactory(MySqlConnectorConfig connectorConfig, MySqlConnection connection) {
        String acceptedTlsVersion = connection.getSessionVariableForSslVersion();
        if (!Strings.isNullOrEmpty((String)acceptedTlsVersion)) {
            SSLMode sslMode = this.sslModeFor(connectorConfig.sslMode());
            String password = System.getProperty("javax.net.ssl.keyStorePassword");
            String keyFilename = System.getProperty("javax.net.ssl.keyStore");
            KeyManager[] keyManagers = null;
            if (keyFilename != null) {
                char[] passwordArray = password == null ? null : password.toCharArray();
                try {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(new FileInputStream(keyFilename), passwordArray);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("NewSunX509");
                    kmf.init(ks, passwordArray);
                    keyManagers = kmf.getKeyManagers();
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    throw new DebeziumException("Could not load keystore", (Throwable)e);
                }
            }
            if (sslMode == SSLMode.PREFERRED || sslMode == SSLMode.REQUIRED) {
                final KeyManager[] finalKMS = keyManagers;
                return new DefaultSSLSocketFactory(acceptedTlsVersion){

                    protected void initSSLContext(SSLContext sc) throws GeneralSecurityException {
                        sc.init(finalKMS, new TrustManager[]{new X509TrustManager(){

                            @Override
                            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                            }

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return new X509Certificate[0];
                            }
                        }}, null);
                    }
                };
            }
            return new DefaultSSLSocketFactory(acceptedTlsVersion);
        }
        return null;
    }

    private void logStreamingSourceState() {
        this.logStreamingSourceState(Level.ERROR);
    }

    protected void logEvent(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.trace("Received event: {}", (Object)event);
    }

    private void logStreamingSourceState(Level severity) {
        String position = this.client == null ? "N/A" : this.client.getBinlogFilename() + "/" + this.client.getBinlogPosition();
        String message = "Error during binlog processing. Last offset stored = {}, binlog reader near position = {}";
        switch (severity) {
            case WARN: {
                LOGGER.warn("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
                break;
            }
            case DEBUG: {
                LOGGER.debug("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
                break;
            }
            default: {
                LOGGER.error("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
            }
        }
    }

    public GtidSet filterGtidSet(MySqlOffsetContext offsetContext, GtidSet availableServerGtidSet, GtidSet purgedServerGtid) {
        GtidSet mergedGtidSet;
        String gtidStr = offsetContext.gtidSet();
        if (gtidStr == null) {
            return null;
        }
        LOGGER.info("Attempting to generate a filtered GTID set");
        LOGGER.info("GTID set from previous recorded offset: {}", (Object)gtidStr);
        GtidSet filteredGtidSet = new GtidSet(gtidStr);
        Predicate gtidSourceFilter = this.connectorConfig.gtidSourceFilter();
        if (gtidSourceFilter != null) {
            filteredGtidSet = filteredGtidSet.retainAll(gtidSourceFilter);
            LOGGER.info("GTID set after applying GTID source includes/excludes to previous recorded offset: {}", (Object)filteredGtidSet);
        }
        LOGGER.info("GTID set available on server: {}", (Object)availableServerGtidSet);
        if (this.connectorConfig.gtidNewChannelPosition() == MySqlConnectorConfig.GtidNewChannelPosition.EARLIEST) {
            GtidSet knownGtidSet = filteredGtidSet;
            LOGGER.info("Using first available positions for new GTID channels");
            GtidSet relevantAvailableServerGtidSet = gtidSourceFilter != null ? availableServerGtidSet.retainAll(gtidSourceFilter) : availableServerGtidSet;
            LOGGER.info("Relevant GTID set available on server: {}", (Object)relevantAvailableServerGtidSet);
            mergedGtidSet = relevantAvailableServerGtidSet.retainAll(uuid -> knownGtidSet.forServerWithId(uuid) != null).with(purgedServerGtid).with(filteredGtidSet);
        } else {
            mergedGtidSet = availableServerGtidSet.with(filteredGtidSet);
        }
        LOGGER.info("Final merged GTID set to use when connecting to MySQL: {}", (Object)mergedGtidSet);
        return mergedGtidSet;
    }

    MySqlStreamingChangeEventSourceMetrics getMetrics() {
        return this.metrics;
    }

    void rewindBinaryLogClient(ChangeEventSource.ChangeEventSourceContext context, BinlogPosition position) {
        try {
            if (context.isRunning()) {
                LOGGER.debug("Rewinding binlog to position {}", (Object)position);
                this.client.disconnect();
                this.client.setBinlogFilename(position.getFilename());
                this.client.setBinlogPosition(position.getPosition());
                this.client.connect();
            }
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error when re-connecting to the MySQL binary log reader", (Throwable)e);
        }
    }

    BinlogPosition getCurrentBinlogPosition() {
        return new BinlogPosition(this.client.getBinlogFilename(), this.client.getBinlogPosition());
    }

    protected DebeziumException wrap(Throwable error) {
        assert (error != null);
        String msg = error.getMessage();
        if (error instanceof ServerException) {
            ServerException e = (ServerException)error;
            msg = msg + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSqlState() + ".";
        } else if (error instanceof SQLException) {
            SQLException e = (SQLException)error;
            msg = e.getMessage() + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSQLState() + ".";
        }
        return new DebeziumException(msg, error);
    }

    @FunctionalInterface
    private static interface RowsProvider<E extends EventData, U> {
        public List<U> getRows(E var1);
    }

    @FunctionalInterface
    private static interface TableIdProvider<E extends EventData> {
        public TableId getTableId(E var1);
    }

    protected final class ReaderThreadLifecycleListener
    implements BinaryLogClient.LifecycleListener {
        private final MySqlOffsetContext offsetContext;

        ReaderThreadLifecycleListener(MySqlOffsetContext offsetContext) {
            this.offsetContext = offsetContext;
        }

        public void onDisconnect(BinaryLogClient client) {
            if (LOGGER.isInfoEnabled()) {
                MySqlStreamingChangeEventSource.this.taskContext.temporaryLoggingContext((CommonConnectorConfig)MySqlStreamingChangeEventSource.this.connectorConfig, "binlog", () -> {
                    Map offset = MySqlStreamingChangeEventSource.this.lastOffset;
                    if (offset != null) {
                        LOGGER.info("Stopped reading binlog after {} events, last recorded offset: {}", (Object)MySqlStreamingChangeEventSource.this.totalRecordCounter, (Object)offset);
                    } else {
                        LOGGER.info("Stopped reading binlog after {} events, no new offset was recorded", (Object)MySqlStreamingChangeEventSource.this.totalRecordCounter);
                    }
                });
            }
        }

        public void onConnect(BinaryLogClient client) {
            MySqlStreamingChangeEventSource.this.taskContext.configureLoggingContext("binlog");
            LOGGER.info("Connected to MySQL binlog at {}:{}, starting at {}", new Object[]{MySqlStreamingChangeEventSource.this.connectorConfig.hostname(), MySqlStreamingChangeEventSource.this.connectorConfig.port(), this.offsetContext});
        }

        public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
            LOGGER.debug("A communication failure event arrived", (Throwable)ex);
            MySqlStreamingChangeEventSource.this.logStreamingSourceState();
            try {
                client.disconnect();
            }
            catch (Exception e) {
                LOGGER.debug("Exception while closing client", (Throwable)e);
            }
            MySqlStreamingChangeEventSource.this.errorHandler.setProducerThrowable((Throwable)MySqlStreamingChangeEventSource.this.wrap(ex));
        }

        public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
            if (MySqlStreamingChangeEventSource.this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.debug("A deserialization failure event arrived", (Throwable)ex);
                MySqlStreamingChangeEventSource.this.logStreamingSourceState();
                MySqlStreamingChangeEventSource.this.errorHandler.setProducerThrowable((Throwable)MySqlStreamingChangeEventSource.this.wrap(ex));
            } else if (MySqlStreamingChangeEventSource.this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("A deserialization failure event arrived", (Throwable)ex);
                MySqlStreamingChangeEventSource.this.logStreamingSourceState(Level.WARN);
            } else {
                LOGGER.debug("A deserialization failure event arrived", (Throwable)ex);
                MySqlStreamingChangeEventSource.this.logStreamingSourceState(Level.DEBUG);
            }
        }
    }

    @FunctionalInterface
    private static interface BinlogChangeEmitter<T> {
        public void emit(TableId var1, T var2) throws InterruptedException;
    }

    public static class BinlogPosition {
        final String filename;
        final long position;

        public BinlogPosition(String filename, long position) {
            assert (filename != null);
            this.filename = filename;
            this.position = position;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getPosition() {
            return this.position;
        }

        public String toString() {
            return this.filename + "/" + this.position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.filename.hashCode();
            result = 31 * result + (int)(this.position ^ this.position >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinlogPosition other = (BinlogPosition)obj;
            if (!this.filename.equals(other.filename)) {
                return false;
            }
            return this.position == other.position;
        }
    }
}

