/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.debezium;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.connection.JdbcConnectionFactory;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.utils.TableDiscoveryUtils;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumUtils {
    private static final String QUOTED_CHARACTER = "`";
    private static final Logger LOG = LoggerFactory.getLogger(DebeziumUtils.class);

    public static JdbcConnection openJdbcConnection(MySqlSourceConfig sourceConfig) {
        JdbcConnection jdbc = new JdbcConnection(JdbcConfiguration.adapt((Configuration)sourceConfig.getDbzConfiguration()), (JdbcConnection.ConnectionFactory)new JdbcConnectionFactory(sourceConfig), QUOTED_CHARACTER, QUOTED_CHARACTER);
        try {
            jdbc.connect();
        }
        catch (Exception e) {
            LOG.error("Failed to open MySQL connection", (Throwable)e);
            throw new FlinkRuntimeException((Throwable)e);
        }
        return jdbc;
    }

    public static MySqlConnection createMySqlConnection(MySqlSourceConfig sourceConfig) {
        return DebeziumUtils.createMySqlConnection(sourceConfig.getDbzConfiguration(), sourceConfig.getJdbcProperties());
    }

    public static MySqlConnection createMySqlConnection(Configuration dbzConfiguration, Properties jdbcProperties) {
        return new MySqlConnection(new MySqlConnection.MySqlConnectionConfiguration(dbzConfiguration, jdbcProperties));
    }

    public static BinaryLogClient createBinaryClient(Configuration dbzConfiguration) {
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(dbzConfiguration);
        return new BinaryLogClient(connectorConfig.hostname(), connectorConfig.port(), connectorConfig.username(), connectorConfig.password());
    }

    public static MySqlDatabaseSchema createMySqlDatabaseSchema(MySqlConnectorConfig dbzMySqlConfig, boolean isTableIdCaseSensitive) {
        TopicSelector topicSelector = MySqlTopicSelector.defaultSelector((MySqlConnectorConfig)dbzMySqlConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        MySqlValueConverters valueConverters = DebeziumUtils.getValueConverters(dbzMySqlConfig);
        return new MySqlDatabaseSchema(dbzMySqlConfig, valueConverters, topicSelector, schemaNameAdjuster, isTableIdCaseSensitive);
    }

    public static BinlogOffset currentBinlogOffset(JdbcConnection jdbc) {
        String showMasterStmt = "SHOW MASTER STATUS";
        try {
            return (BinlogOffset)jdbc.queryAndMap("SHOW MASTER STATUS", rs -> {
                if (rs.next()) {
                    String binlogFilename = rs.getString(1);
                    long binlogPosition = rs.getLong(2);
                    String gtidSet = rs.getMetaData().getColumnCount() > 4 ? rs.getString(5) : null;
                    return BinlogOffset.builder().setBinlogFilePosition(binlogFilename, binlogPosition).setGtidSet(gtidSet).build();
                }
                throw new FlinkRuntimeException("Cannot read the binlog filename and position via 'SHOW MASTER STATUS'. Make sure your server is correctly configured");
            });
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Cannot read the binlog filename and position via 'SHOW MASTER STATUS'. Make sure your server is correctly configured", (Throwable)e);
        }
    }

    public static Tables.TableFilter createTableFilter(String database, String table) {
        Selectors.TableSelectionPredicateBuilder eligibleTables = Selectors.tableSelector().includeDatabases(database);
        Predicate tablePredicate = eligibleTables.includeTables(table).build();
        Predicate<TableId> finalTablePredicate = tablePredicate.and(arg_0 -> ((Tables.TableFilter)Tables.TableFilter.fromPredicate(MySqlConnectorConfig::isNotBuiltInTable)).isIncluded(arg_0));
        return finalTablePredicate::test;
    }

    private static MySqlValueConverters getValueConverters(MySqlConnectorConfig dbzMySqlConfig) {
        TemporalPrecisionMode timePrecisionMode = dbzMySqlConfig.getTemporalPrecisionMode();
        JdbcValueConverters.DecimalMode decimalMode = dbzMySqlConfig.getDecimalMode();
        String bigIntUnsignedHandlingModeStr = dbzMySqlConfig.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse((String)bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        boolean timeAdjusterEnabled = dbzMySqlConfig.getConfig().getBoolean(MySqlConnectorConfig.ENABLE_TIME_ADJUSTER);
        return new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode, dbzMySqlConfig.binaryHandlingMode(), timeAdjusterEnabled ? MySqlValueConverters::adjustTemporal : x -> x, MySqlValueConverters::defaultParsingErrorHandler);
    }

    public static List<TableId> discoverCapturedTables(JdbcConnection jdbc, MySqlSourceConfig sourceConfig) {
        List<TableId> capturedTableIds;
        try {
            capturedTableIds = TableDiscoveryUtils.listTables(jdbc, sourceConfig.getTableFilters());
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to discover captured tables", (Throwable)e);
        }
        if (capturedTableIds.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't find any matched tables, please check your configured database-name: %s and table-name: %s", sourceConfig.getDatabaseList(), sourceConfig.getTableList()));
        }
        return capturedTableIds;
    }

    public static boolean isTableIdCaseSensitive(JdbcConnection connection) {
        return !"0".equals(DebeziumUtils.readMySqlSystemVariables(connection).get("lower_case_table_names"));
    }

    public static Map<String, String> readMySqlSystemVariables(JdbcConnection connection) {
        return DebeziumUtils.querySystemVariables(connection, "SHOW VARIABLES");
    }

    private static Map<String, String> querySystemVariables(JdbcConnection connection, String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            connection.query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                }
            });
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }
}

