/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.assigners;

import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.schema.MySqlSchema;
import com.ververica.cdc.connectors.mysql.source.assigners.AssignerStatus;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlChunkSplitter;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.state.ChunkSplitterState;
import com.ververica.cdc.connectors.mysql.source.assigners.state.SnapshotPendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSchemalessSnapshotSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSnapshotSplitAssigner
implements MySqlSplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSnapshotSplitAssigner.class);
    private final List<TableId> alreadyProcessedTables;
    private final List<MySqlSchemalessSnapshotSplit> remainingSplits;
    private final Map<String, MySqlSchemalessSnapshotSplit> assignedSplits;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    private final Map<String, BinlogOffset> splitFinishedOffsets;
    private final MySqlSourceConfig sourceConfig;
    private final int currentParallelism;
    private final List<TableId> remainingTables;
    private final boolean isRemainingTablesCheckpointed;
    private final MySqlPartition partition;
    private final Object lock = new Object();
    private volatile Throwable uncaughtSplitterException;
    private AssignerStatus assignerStatus;
    private MySqlChunkSplitter chunkSplitter;
    private boolean isTableIdCaseSensitive;
    private ExecutorService executor;
    @Nullable
    private Long checkpointIdToFinish;

    public MySqlSnapshotSplitAssigner(MySqlSourceConfig sourceConfig, int currentParallelism, List<TableId> remainingTables, boolean isTableIdCaseSensitive) {
        this(sourceConfig, currentParallelism, new ArrayList<TableId>(), new ArrayList<MySqlSchemalessSnapshotSplit>(), new LinkedHashMap<String, MySqlSchemalessSnapshotSplit>(), new HashMap<TableId, TableChanges.TableChange>(), new HashMap<String, BinlogOffset>(), AssignerStatus.INITIAL_ASSIGNING, remainingTables, isTableIdCaseSensitive, true, ChunkSplitterState.NO_SPLITTING_TABLE_STATE);
    }

    public MySqlSnapshotSplitAssigner(MySqlSourceConfig sourceConfig, int currentParallelism, SnapshotPendingSplitsState checkpoint) {
        this(sourceConfig, currentParallelism, checkpoint.getAlreadyProcessedTables(), checkpoint.getRemainingSplits(), checkpoint.getAssignedSplits(), checkpoint.getTableSchemas(), checkpoint.getSplitFinishedOffsets(), checkpoint.getSnapshotAssignerStatus(), checkpoint.getRemainingTables(), checkpoint.isTableIdCaseSensitive(), checkpoint.isRemainingTablesCheckpointed(), checkpoint.getChunkSplitterState());
    }

    private MySqlSnapshotSplitAssigner(MySqlSourceConfig sourceConfig, int currentParallelism, List<TableId> alreadyProcessedTables, List<MySqlSchemalessSnapshotSplit> remainingSplits, Map<String, MySqlSchemalessSnapshotSplit> assignedSplits, Map<TableId, TableChanges.TableChange> tableSchemas, Map<String, BinlogOffset> splitFinishedOffsets, AssignerStatus assignerStatus, List<TableId> remainingTables, boolean isTableIdCaseSensitive, boolean isRemainingTablesCheckpointed, ChunkSplitterState chunkSplitterState) {
        this.sourceConfig = sourceConfig;
        this.currentParallelism = currentParallelism;
        this.alreadyProcessedTables = alreadyProcessedTables;
        this.remainingSplits = new CopyOnWriteArrayList<MySqlSchemalessSnapshotSplit>(remainingSplits);
        this.assignedSplits = assignedSplits.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, o2) -> o, LinkedHashMap::new));
        this.tableSchemas = tableSchemas;
        this.splitFinishedOffsets = splitFinishedOffsets;
        this.assignerStatus = assignerStatus;
        this.remainingTables = new CopyOnWriteArrayList<TableId>(remainingTables);
        this.isRemainingTablesCheckpointed = isRemainingTablesCheckpointed;
        this.isTableIdCaseSensitive = isTableIdCaseSensitive;
        this.chunkSplitter = MySqlSnapshotSplitAssigner.createChunkSplitter(sourceConfig, isTableIdCaseSensitive, chunkSplitterState);
        this.partition = new MySqlPartition(sourceConfig.getMySqlConnectorConfig().getLogicalName());
    }

    @Override
    public void open() {
        this.chunkSplitter.open();
        this.discoveryCaptureTables();
        this.captureNewlyAddedTables();
        this.startAsynchronouslySplit();
    }

    private void discoveryCaptureTables() {
        if (this.needToDiscoveryTables()) {
            long start = System.currentTimeMillis();
            LOG.debug("The remainingTables is empty, start to discovery tables");
            try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(this.sourceConfig);){
                List<TableId> discoverTables = DebeziumUtils.discoverCapturedTables(jdbc, this.sourceConfig);
                this.remainingTables.addAll(discoverTables);
                this.isTableIdCaseSensitive = DebeziumUtils.isTableIdCaseSensitive(jdbc);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discovery tables to capture", (Throwable)e);
            }
            LOG.debug("Discovery tables success, time cost: {} ms.", (Object)(System.currentTimeMillis() - start));
        } else if (!this.isRemainingTablesCheckpointed && !AssignerStatus.isSnapshotAssigningFinished(this.assignerStatus)) {
            try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(this.sourceConfig);){
                List<TableId> discoverTables = DebeziumUtils.discoverCapturedTables(jdbc, this.sourceConfig);
                discoverTables.removeAll(this.alreadyProcessedTables);
                this.remainingTables.addAll(discoverTables);
                this.isTableIdCaseSensitive = DebeziumUtils.isTableIdCaseSensitive(jdbc);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discover remaining tables to capture", (Throwable)e);
            }
        }
    }

    private void captureNewlyAddedTables() {
        if (this.sourceConfig.isScanNewlyAddedTableEnabled()) {
            try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(this.sourceConfig);){
                List<TableId> currentCapturedTables = DebeziumUtils.discoverCapturedTables(jdbc, this.sourceConfig);
                HashSet<Object> previousCapturedTables = new HashSet<Object>();
                List tablesInRemainingSplits = this.remainingSplits.stream().map(MySqlSnapshotSplit::getTableId).collect(Collectors.toList());
                previousCapturedTables.addAll(tablesInRemainingSplits);
                previousCapturedTables.addAll(this.alreadyProcessedTables);
                previousCapturedTables.addAll(this.remainingTables);
                HashSet tablesToRemove = new HashSet(previousCapturedTables);
                tablesToRemove.removeAll(currentCapturedTables);
                currentCapturedTables.removeAll(previousCapturedTables);
                List<TableId> newlyAddedTables = currentCapturedTables;
                if (!tablesToRemove.isEmpty()) {
                    LinkedList<String> splitsToRemove = new LinkedList<String>();
                    for (Map.Entry<String, MySqlSchemalessSnapshotSplit> splitEntry : this.assignedSplits.entrySet()) {
                        if (!tablesToRemove.contains(splitEntry.getValue().getTableId())) continue;
                        splitsToRemove.add(splitEntry.getKey());
                    }
                    splitsToRemove.forEach(this.assignedSplits.keySet()::remove);
                    splitsToRemove.forEach(this.splitFinishedOffsets.keySet()::remove);
                    this.tableSchemas.entrySet().removeIf(schema -> tablesToRemove.contains(schema.getKey()));
                    this.remainingSplits.removeIf(split -> tablesToRemove.contains(split.getTableId()));
                    this.remainingTables.removeAll(tablesToRemove);
                    this.alreadyProcessedTables.removeIf(tableId -> tablesToRemove.contains(tableId));
                }
                if (!newlyAddedTables.isEmpty()) {
                    LOG.info("Found newly added tables, start capture newly added tables process");
                    this.remainingTables.addAll(newlyAddedTables);
                    if (AssignerStatus.isAssigningFinished(this.assignerStatus)) {
                        LOG.info("Found newly added tables, start capture newly added tables process under binlog reading phase");
                        this.startAssignNewlyAddedTables();
                    }
                }
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discover remaining tables to capture", (Throwable)e);
            }
        }
    }

    private void startAsynchronouslySplit() {
        if (this.chunkSplitter.hasNextChunk() || !this.remainingTables.isEmpty()) {
            if (this.executor == null) {
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("snapshot-splitting").build();
                this.executor = Executors.newSingleThreadExecutor(threadFactory);
            }
            this.executor.submit(this::splitChunksForRemainingTables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitTable(TableId nextTable) {
        LOG.info("Start splitting table {} into chunks...", (Object)nextTable);
        long start = System.currentTimeMillis();
        int chunkNum = 0;
        boolean hasRecordSchema = false;
        do {
            Object object = this.lock;
            synchronized (object) {
                List<MySqlSnapshotSplit> splits;
                try {
                    splits = this.chunkSplitter.splitChunks(this.partition, nextTable);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error when splitting chunks for " + nextTable, e);
                }
                if (!hasRecordSchema && !splits.isEmpty()) {
                    hasRecordSchema = true;
                    HashMap<TableId, TableChanges.TableChange> tableSchema = new HashMap<TableId, TableChanges.TableChange>();
                    tableSchema.putAll(splits.iterator().next().getTableSchemas());
                    this.tableSchemas.putAll(tableSchema);
                }
                List schemaLessSnapshotSplits = splits.stream().map(MySqlSnapshotSplit::toSchemalessSnapshotSplit).collect(Collectors.toList());
                chunkNum += splits.size();
                this.remainingSplits.addAll(schemaLessSnapshotSplits);
                if (!this.chunkSplitter.hasNextChunk()) {
                    this.remainingTables.remove(nextTable);
                }
                this.lock.notify();
            }
        } while (this.chunkSplitter.hasNextChunk());
        long end = System.currentTimeMillis();
        LOG.info("Split table {} into {} chunks, time cost: {}ms.", new Object[]{nextTable, chunkNum, end - start});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<MySqlSplit> getNext() {
        this.waitTableDiscoveryReady();
        Object object = this.lock;
        synchronized (object) {
            this.checkSplitterErrors();
            if (!this.remainingSplits.isEmpty()) {
                Iterator<MySqlSchemalessSnapshotSplit> iterator = this.remainingSplits.iterator();
                MySqlSchemalessSnapshotSplit split = iterator.next();
                this.remainingSplits.remove(split);
                this.assignedSplits.put(split.splitId(), split);
                this.addAlreadyProcessedTablesIfNotExists(split.getTableId());
                return Optional.of(split.toMySqlSnapshotSplit(this.tableSchemas.get(split.getTableId())));
            }
            if (!this.remainingTables.isEmpty()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new FlinkRuntimeException("InterruptedException while waiting for asynchronously snapshot split");
                }
                return this.getNext();
            }
            this.closeExecutorService();
            return Optional.empty();
        }
    }

    @Override
    public boolean waitingForFinishedSplits() {
        return !this.allSnapshotSplitsFinished();
    }

    @Override
    public List<FinishedSnapshotSplitInfo> getFinishedSplitInfos() {
        if (this.waitingForFinishedSplits()) {
            LOG.error("The assigner is not ready to offer finished split information, this should not be called");
            throw new FlinkRuntimeException("The assigner is not ready to offer finished split information, this should not be called");
        }
        ArrayList<MySqlSchemalessSnapshotSplit> assignedSnapshotSplit = new ArrayList<MySqlSchemalessSnapshotSplit>(this.assignedSplits.values());
        ArrayList<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = new ArrayList<FinishedSnapshotSplitInfo>();
        for (MySqlSchemalessSnapshotSplit split : assignedSnapshotSplit) {
            BinlogOffset binlogOffset = this.splitFinishedOffsets.get(split.splitId());
            finishedSnapshotSplitInfos.add(new FinishedSnapshotSplitInfo(split.getTableId(), split.splitId(), split.getSplitStart(), split.getSplitEnd(), binlogOffset));
        }
        return finishedSnapshotSplitInfos;
    }

    @Override
    public void onFinishedSplits(Map<String, BinlogOffset> splitFinishedOffsets) {
        this.splitFinishedOffsets.putAll(splitFinishedOffsets);
        if (this.allSnapshotSplitsFinished() && AssignerStatus.isAssigningSnapshotSplits(this.assignerStatus)) {
            if (this.currentParallelism == 1) {
                this.assignerStatus = this.assignerStatus.onFinish();
                LOG.info("Snapshot split assigner received all splits finished and the job parallelism is 1, snapshot split assigner is turn into finished status.");
            } else {
                LOG.info("Snapshot split assigner received all splits finished, waiting for a complete checkpoint to mark the assigner finished.");
            }
        }
    }

    @Override
    public void addSplits(Collection<MySqlSplit> splits) {
        for (MySqlSplit split : splits) {
            this.tableSchemas.putAll(split.asSnapshotSplit().getTableSchemas());
            this.remainingSplits.add(split.asSnapshotSplit().toSchemalessSnapshotSplit());
            this.assignedSplits.remove(split.splitId());
            this.splitFinishedOffsets.remove(split.splitId());
        }
    }

    @Override
    public SnapshotPendingSplitsState snapshotState(long checkpointId) {
        SnapshotPendingSplitsState state = new SnapshotPendingSplitsState(this.alreadyProcessedTables, this.remainingSplits, this.assignedSplits, this.tableSchemas, this.splitFinishedOffsets, this.assignerStatus, this.remainingTables, this.isTableIdCaseSensitive, true, this.chunkSplitter.snapshotState(checkpointId));
        if (this.checkpointIdToFinish == null && !AssignerStatus.isSnapshotAssigningFinished(this.assignerStatus) && this.allSnapshotSplitsFinished()) {
            this.checkpointIdToFinish = checkpointId;
        }
        return state;
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
        if (this.checkpointIdToFinish != null && AssignerStatus.isAssigningSnapshotSplits(this.assignerStatus) && this.allSnapshotSplitsFinished()) {
            if (checkpointId >= this.checkpointIdToFinish) {
                this.assignerStatus = this.assignerStatus.onFinish();
            }
            LOG.info("Snapshot split assigner is turn into finished status.");
        }
    }

    @Override
    public AssignerStatus getAssignerStatus() {
        return this.assignerStatus;
    }

    @Override
    public void startAssignNewlyAddedTables() {
        Preconditions.checkState((boolean)AssignerStatus.isAssigningFinished(this.assignerStatus), (String)"Invalid assigner status {}", (Object[])new Object[]{this.assignerStatus});
        this.assignerStatus = this.assignerStatus.startAssignNewlyTables();
    }

    @Override
    public void onBinlogSplitUpdated() {
        Preconditions.checkState((boolean)AssignerStatus.isNewlyAddedAssigningSnapshotFinished(this.assignerStatus), (String)"Invalid assigner status {}", (Object[])new Object[]{this.assignerStatus});
        this.assignerStatus = this.assignerStatus.onBinlogSplitUpdated();
    }

    @Override
    public void close() {
        this.closeExecutorService();
        if (this.chunkSplitter != null) {
            try {
                this.chunkSplitter.close();
            }
            catch (Exception e) {
                LOG.warn("Fail to close the chunk splitter.");
            }
        }
    }

    private void closeExecutorService() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private void addAlreadyProcessedTablesIfNotExists(TableId tableId) {
        if (!this.alreadyProcessedTables.contains(tableId)) {
            this.alreadyProcessedTables.add(tableId);
        }
    }

    private void waitTableDiscoveryReady() {
        while (this.needToDiscoveryTables()) {
            LOG.debug("Current assigner is discovering tables, wait tables ready...");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean noMoreSnapshotSplits() {
        return !this.needToDiscoveryTables() && this.remainingTables.isEmpty() && this.remainingSplits.isEmpty();
    }

    public boolean needToDiscoveryTables() {
        return this.remainingTables.isEmpty() && this.remainingSplits.isEmpty() && this.alreadyProcessedTables.isEmpty();
    }

    public Map<String, MySqlSchemalessSnapshotSplit> getAssignedSplits() {
        return this.assignedSplits;
    }

    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public Map<String, BinlogOffset> getSplitFinishedOffsets() {
        return this.splitFinishedOffsets;
    }

    private boolean allSnapshotSplitsFinished() {
        return this.noMoreSnapshotSplits() && this.assignedSplits.size() == this.splitFinishedOffsets.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitChunksForRemainingTables() {
        try {
            if (this.chunkSplitter.hasNextChunk()) {
                LOG.info("Start splitting remaining chunks for table {}", (Object)this.chunkSplitter.getCurrentSplittingTableId());
                this.splitTable(this.chunkSplitter.getCurrentSplittingTableId());
            }
            for (TableId nextTable : this.remainingTables) {
                this.splitTable(nextTable);
            }
        }
        catch (Throwable e) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uncaughtSplitterException == null) {
                    this.uncaughtSplitterException = e;
                } else {
                    this.uncaughtSplitterException.addSuppressed(e);
                }
                this.lock.notify();
            }
        }
    }

    private void checkSplitterErrors() {
        if (this.uncaughtSplitterException != null) {
            throw new FlinkRuntimeException("Chunk splitting has encountered exception", this.uncaughtSplitterException);
        }
    }

    private static MySqlChunkSplitter createChunkSplitter(MySqlSourceConfig sourceConfig, boolean isTableIdCaseSensitive, ChunkSplitterState chunkSplitterState) {
        MySqlSchema mySqlSchema = new MySqlSchema(sourceConfig, isTableIdCaseSensitive);
        if (!ChunkSplitterState.NO_SPLITTING_TABLE_STATE.equals(chunkSplitterState)) {
            TableId tableId = chunkSplitterState.getCurrentSplittingTableId();
            return new MySqlChunkSplitter(mySqlSchema, sourceConfig, tableId != null && sourceConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId) ? chunkSplitterState : ChunkSplitterState.NO_SPLITTING_TABLE_STATE);
        }
        return new MySqlChunkSplitter(mySqlSchema, sourceConfig);
    }
}

