/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.config;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class ServerIdRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int startServerId;
    private final int endServerId;

    public ServerIdRange(int startServerId, int endServerId) {
        this.startServerId = startServerId;
        this.endServerId = endServerId;
    }

    public int getStartServerId() {
        return this.startServerId;
    }

    public int getEndServerId() {
        return this.endServerId;
    }

    public int getServerId(int subTaskId) {
        Preconditions.checkArgument((subTaskId >= 0 ? 1 : 0) != 0, (String)"Subtask ID %s shouldn't be a negative number.", (Object[])new Object[]{subTaskId});
        if (subTaskId > this.getNumberOfServerIds()) {
            throw new IllegalArgumentException(String.format("Subtask ID %s is out of server id range %s, please adjust the server id range to make the number of server id larger than the source parallelism.", subTaskId, this.toString()));
        }
        return this.startServerId + subTaskId;
    }

    public int getNumberOfServerIds() {
        return this.endServerId - this.startServerId + 1;
    }

    public String toString() {
        if (this.startServerId == this.endServerId) {
            return String.valueOf(this.startServerId);
        }
        return this.startServerId + "-" + this.endServerId;
    }

    @Nullable
    public static ServerIdRange from(@Nullable String range) {
        if (range == null) {
            return null;
        }
        if (range.contains("-")) {
            String[] idArray = range.split("-");
            if (idArray.length != 2) {
                throw new IllegalArgumentException(String.format("The server id range should be syntax like '5400-5500', but got: %s", range));
            }
            return new ServerIdRange(ServerIdRange.parseServerId(idArray[0].trim()), ServerIdRange.parseServerId(idArray[1].trim()));
        }
        int serverId = ServerIdRange.parseServerId(range);
        return new ServerIdRange(serverId, serverId);
    }

    private static int parseServerId(String serverIdValue) {
        try {
            return Integer.parseInt(serverIdValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("The server id %s is not a valid numeric.", serverIdValue), e);
        }
    }
}

