/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.utils;

import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.schema.MySqlTypeUtils;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static RowType getChunkKeyColumnType(Table table, Map<ObjectPath, String> chunkKeyColumns) {
        return ChunkUtils.getChunkKeyColumnType(ChunkUtils.getChunkKeyColumn(table, chunkKeyColumns));
    }

    public static RowType getChunkKeyColumnType(Column chunkKeyColumn) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)chunkKeyColumn.name(), (DataType)MySqlTypeUtils.fromDbzColumn(chunkKeyColumn))}).getLogicalType();
    }

    public static Column getChunkKeyColumn(Table table, Map<ObjectPath, String> chunkKeyColumns) {
        List searchColumns;
        List primaryKeys = table.primaryKeyColumns();
        String chunkKeyColumn = ChunkUtils.findChunkKeyColumn(table.id(), chunkKeyColumns);
        if (primaryKeys.isEmpty() && chunkKeyColumn == null) {
            throw new ValidationException("'scan.incremental.snapshot.chunk.key-column' must be set when the table doesn't have primary keys.");
        }
        List list = searchColumns = primaryKeys.isEmpty() ? table.columns() : primaryKeys;
        if (chunkKeyColumn != null) {
            Optional<Column> targetColumn = searchColumns.stream().filter(col -> chunkKeyColumn.equals(col.name())).findFirst();
            if (targetColumn.isPresent()) {
                return targetColumn.get();
            }
            throw new ValidationException(String.format("Chunk key column '%s' doesn't exist in the %s [%s] of the table %s.", chunkKeyColumn, primaryKeys.isEmpty() ? "user specified columns" : "primary keys", searchColumns.stream().map(Column::name).collect(Collectors.joining(",")), table.id()));
        }
        return (Column)primaryKeys.get(0);
    }

    @Nullable
    private static String findChunkKeyColumn(TableId tableId, Map<ObjectPath, String> chunkKeyColumns) {
        for (ObjectPath table : chunkKeyColumns.keySet()) {
            Tables.TableFilter filter = DebeziumUtils.createTableFilter(table.getDatabaseName(), table.getFullName());
            if (!filter.isIncluded(tableId)) continue;
            return chunkKeyColumns.get(table);
        }
        return null;
    }

    public static int getNextMetaGroupId(int receivedMetaNum, int metaGroupSize) {
        Preconditions.checkState((metaGroupSize > 0 ? 1 : 0) != 0);
        return receivedMetaNum / metaGroupSize;
    }
}

