/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc;

import com.vladsch.flexmark.ext.toc.TocBlockBase;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class SimTocBlock
extends TocBlockBase {
    protected BasedSequence anchorMarker = BasedSequence.NULL;
    protected BasedSequence openingTitleMarker = BasedSequence.NULL;
    protected BasedSequence title = BasedSequence.NULL;
    protected BasedSequence closingTitleMarker = BasedSequence.NULL;

    @Override
    public void getAstExtra(StringBuilder out) {
        super.getAstExtra(out);
        SimTocBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorMarker, (String)"anchorMarker");
        SimTocBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.openingTitleMarker, (String)"openingTitleMarker");
        SimTocBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.title, (String)"title");
        SimTocBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.closingTitleMarker, (String)"closingTitleMarker");
    }

    @Override
    public BasedSequence[] getSegments() {
        BasedSequence[] nodeSegments = new BasedSequence[]{this.openingMarker, this.tocKeyword, this.style, this.closingMarker, this.anchorMarker, this.openingTitleMarker, this.title, this.closingTitleMarker};
        if (this.lineSegments.size() == 0) {
            return nodeSegments;
        }
        BasedSequence[] allSegments = new BasedSequence[this.lineSegments.size() + nodeSegments.length];
        this.lineSegments.toArray(allSegments);
        System.arraycopy(allSegments, 0, allSegments, nodeSegments.length, this.lineSegments.size());
        return allSegments;
    }

    public SimTocBlock(BasedSequence chars) {
        this(chars, null, null);
    }

    public SimTocBlock(BasedSequence chars, BasedSequence styleChars, BasedSequence titleChars) {
        super(chars, styleChars, true);
        int anchorPos = chars.indexOf('#', this.closingMarker.getEndOffset() - chars.getStartOffset());
        if (anchorPos == -1) {
            throw new IllegalStateException("Invalid TOC block sequence");
        }
        this.anchorMarker = chars.subSequence(anchorPos, anchorPos + 1);
        if (titleChars != null) {
            if (titleChars.length() < 2) {
                throw new IllegalStateException("Invalid TOC block title sequence");
            }
            this.openingTitleMarker = titleChars.subSequence(0, 1);
            this.title = titleChars.midSequence(1, -1).nullIfEmpty();
            this.closingTitleMarker = titleChars.endSequence(1);
        }
    }

    public BasedSequence getAnchorMarker() {
        return this.anchorMarker;
    }

    public BasedSequence getOpeningTitleMarker() {
        return this.openingTitleMarker;
    }

    public BasedSequence getTitle() {
        return this.title;
    }

    public BasedSequence getClosingTitleMarker() {
        return this.closingTitleMarker;
    }
}

