/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtils {
    public static Image getImageFromClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        return ImageUtils.getImageFromTransferable(transferable);
    }

    public static Image getImageFromTransferable(Transferable transferable) {
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                return (Image)transferable.getTransferData(DataFlavor.imageFlavor);
            }
            return null;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return null;
    }

    public static BufferedImage scaleImage(BufferedImage sourceImage, int newWidth, int newHeight, int opType) {
        if (sourceImage == null) {
            return null;
        }
        if (newWidth == 0 || newHeight == 0) {
            return null;
        }
        AffineTransform at = AffineTransform.getScaleInstance((double)newWidth / (double)sourceImage.getWidth(null), (double)newHeight / (double)sourceImage.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(at, opType != 0 ? opType : 2);
        return op.filter(sourceImage, null);
    }

    public static BufferedImage toBufferedImage(Image src) {
        if (src instanceof BufferedImage) {
            return (BufferedImage)src;
        }
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        if (w < 0 || h < 0) {
            return null;
        }
        int type = 2;
        BufferedImage dest = new BufferedImage(w, h, type);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public static void save(BufferedImage image, File file, String format) {
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (Throwable e) {
            System.out.println("Write error for " + file.getPath() + ": " + e.getMessage());
        }
    }

    public static BufferedImage loadImageFromFile(File cachedImageFile) {
        if (cachedImageFile == null || !cachedImageFile.isFile()) {
            return null;
        }
        try {
            for (int i = 0; i < 3; ++i) {
                BufferedImage read = null;
                try {
                    read = ImageIO.read(cachedImageFile);
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.print("*");
                    System.err.println("could not read" + cachedImageFile);
                    continue;
                }
                if (i > 0) {
                    System.err.println("");
                }
                return read;
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    public static BufferedImage loadImageFromURL(String imageURL) {
        try {
            return ImageUtils.toBufferedImage(new ImageIcon(new URL(imageURL)).getImage());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius, int borderWidth) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage addBorder(BufferedImage image, Color borderColor, int borderWidth, int cornerRadius) {
        int w = image.getWidth() + borderWidth * 2;
        int h = image.getHeight() + borderWidth * 2;
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setColor(borderColor);
        g2.drawImage((Image)image, borderWidth, borderWidth, null);
        g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (cornerRadius > 0) {
            g2.drawRoundRect(borderWidth / 2, borderWidth / 2, w - borderWidth, h - borderWidth, cornerRadius, cornerRadius);
        } else {
            g2.drawRect(borderWidth / 2, borderWidth / 2, w - borderWidth, h - borderWidth);
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage drawRectangle(BufferedImage image, int x, int y, int w, int h, Color borderColor, int borderWidth, int cornerRadius) {
        boolean invert;
        BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = output.createGraphics();
        boolean bl = invert = borderColor == null;
        if (invert) {
            int rgb = image.getRGB(x + w / 2, y + h / 2);
            borderColor = Color.getColor("", ~(rgb & 0xFFFFFF));
        }
        g2.drawImage((Image)image, 0, 0, null);
        g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (invert) {
            // empty if block
        }
        g2.setColor(borderColor);
        if (cornerRadius > 0) {
            g2.drawRoundRect(x, y, w, h, cornerRadius, cornerRadius);
        } else {
            g2.drawRect(x, y, w, h);
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage cropImage(BufferedImage image, int trimLeft, int trimRight, int trimTop, int trimBottom) {
        BufferedImage output = image.getSubimage(trimLeft, trimTop, image.getWidth() - trimLeft - trimRight, image.getHeight() - trimTop - trimBottom);
        return output;
    }

    public static BufferedImage removeAlpha(BufferedImage image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), Color.WHITE, null);
        g.dispose();
        return bufferedImage;
    }

    public static Image toTransparent(BufferedImage image, final Color color, final int tolerance) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            int radius;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
                this.radius = tolerance * tolerance * 3;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int delta3;
                int delta2;
                int delta1;
                int radDiff;
                if (tolerance == 0 && (rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                if ((rgb & 0xFF000000) == -16777216 && (radDiff = (delta1 = ((rgb & 0xFF0000) >> 16) - ((this.markerRGB & 0xFF0000) >> 16)) * delta1 + (delta2 = ((rgb & 0xFF00) >> 8) - ((this.markerRGB & 0xFF00) >> 8)) * delta2 + (delta3 = (rgb & 0xFF) - (this.markerRGB & 0xFF)) * delta3) <= this.radius) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static byte[] getImageBytes(BufferedImage image) {
        Object imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", bos);
            byte[] imageBytes = bos.toByteArray();
            bos.close();
            return imageBytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

