/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging.util;

import com.vmware.cis.tagging.CategoryDefinitions;
import com.vmware.cis.tagging.StructDefinitions;
import com.vmware.cis.tagging.TagAssociationDefinitions;
import com.vmware.cis.tagging.TagDefinitions;
import com.vmware.vapi.bindings.type.StructType;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.category_model", StructDefinitions.categoryModel);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.tag_model", StructDefinitions.tagModel);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.category.create_spec", CategoryDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.category.update_spec", CategoryDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.tag.create_spec", TagDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.tag.update_spec", TagDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.tag_association.batch_result", TagAssociationDefinitions.batchResult);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.tag_association.tag_to_objects", TagAssociationDefinitions.tagToObjects);
        StructTypeUtil.add(mapping, "com.vmware.cis.tagging.tag_association.object_to_tags", TagAssociationDefinitions.objectToTags);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

