/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter;

import com.vmware.vapi.bindings.type.BooleanType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.IntegerType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SecretType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.bindings.type.VoidType;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.OperationDef;
import com.vmware.vapi.internal.data.UnionValidator;
import com.vmware.vcenter.HostTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class HostDefinitions {
    public static final StructType createSpec = HostDefinitions.createSpecInit();
    public static final StructType filterSpec = HostDefinitions.filterSpecInit();
    public static final StructType summary = HostDefinitions.summaryInit();
    public static final StructType __createInput = HostDefinitions.__createInputInit();
    public static final Type __createOutput = new IdType("HostSystem");
    public static final OperationDef __createDef = HostDefinitions.__createDefInit();
    public static final StructType __deleteInput = HostDefinitions.__deleteInputInit();
    public static final Type __deleteOutput = new VoidType();
    public static final OperationDef __deleteDef = HostDefinitions.__deleteDefInit();
    public static final StructType __listInput = HostDefinitions.__listInputInit();
    public static final Type __listOutput = new ListType((Type)new TypeReference<StructType>(){

        public StructType resolve() {
            return summary;
        }
    });
    public static final OperationDef __listDef = HostDefinitions.__listDefInit();
    public static final StructType __connectInput = HostDefinitions.__connectInputInit();
    public static final Type __connectOutput = new VoidType();
    public static final OperationDef __connectDef = HostDefinitions.__connectDefInit();
    public static final StructType __disconnectInput = HostDefinitions.__disconnectInputInit();
    public static final Type __disconnectOutput = new VoidType();
    public static final OperationDef __disconnectDef = HostDefinitions.__disconnectDefInit();
    public static final List<OperationDef> __operationDefs = Arrays.asList(__createDef, __deleteDef, __listDef, __connectDef, __disconnectDef);

    private static StructType createSpecInit() {
        StructType.FieldNameDetails details = null;
        ArrayList<UnionValidator> validators = null;
        HashMap<String, List<UnionValidator.FieldData>> caseFields = null;
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("hostname", new StringType());
        details = new StructType.FieldNameDetails("hostname", "hostname", "getHostname", "setHostname");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new OptionalType((Type)new IntegerType()));
        details = new StructType.FieldNameDetails("port", "port", "getPort", "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_name", new StringType());
        details = new StructType.FieldNameDetails("user_name", "userName", "getUserName", "setUserName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("password", new SecretType());
        details = new StructType.FieldNameDetails("password", "password", "getPassword", "setPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("folder", new OptionalType((Type)new IdType("Folder")));
        details = new StructType.FieldNameDetails("folder", "folder", "getFolder", "setFolder");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("thumbprint_verification", new EnumType("com.vmware.vcenter.host.create_spec.thumbprint_verification", HostTypes.CreateSpec.ThumbprintVerification.class));
        details = new StructType.FieldNameDetails("thumbprint_verification", "thumbprintVerification", "getThumbprintVerification", "setThumbprintVerification");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("thumbprint", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("thumbprint", "thumbprint", "getThumbprint", "setThumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("force_add", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("force_add", "forceAdd", "getForceAdd", "setForceAdd");
        fieldNameDetails.put(details.getCanonicalName(), details);
        validators = new ArrayList<UnionValidator>(1);
        caseFields = new HashMap<String, List<UnionValidator.FieldData>>();
        caseFields.put("THUMBPRINT", Arrays.asList(new UnionValidator.FieldData("thumbprint", false)));
        caseFields.put("NONE", Arrays.asList(new UnionValidator.FieldData[0]));
        validators.add(new UnionValidator("thumbprint_verification", caseFields));
        return new StructType("com.vmware.vcenter.host.create_spec", fields, HostTypes.CreateSpec.class, validators, false, null, fieldNameDetails);
    }

    private static StructType filterSpecInit() {
        StructType.FieldNameDetails details = null;
        List validators = null;
        LinkedHashMap<String, OptionalType> fields = new LinkedHashMap<String, OptionalType>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("hosts", new OptionalType((Type)new SetType((Type)new IdType("HostSystem"))));
        details = new StructType.FieldNameDetails("hosts", "hosts", "getHosts", "setHosts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("names", new OptionalType((Type)new SetType((Type)new StringType())));
        details = new StructType.FieldNameDetails("names", "names", "getNames", "setNames");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("folders", new OptionalType((Type)new SetType((Type)new IdType("Folder"))));
        details = new StructType.FieldNameDetails("folders", "folders", "getFolders", "setFolders");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("datacenters", new OptionalType((Type)new SetType((Type)new IdType("Datacenter"))));
        details = new StructType.FieldNameDetails("datacenters", "datacenters", "getDatacenters", "setDatacenters");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("standalone", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("standalone", "standalone", "getStandalone", "setStandalone");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("clusters", new OptionalType((Type)new SetType((Type)new IdType("ClusterComputeResource"))));
        details = new StructType.FieldNameDetails("clusters", "clusters", "getClusters", "setClusters");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_states", new OptionalType((Type)new SetType((Type)new EnumType("com.vmware.vcenter.host.connection_state", HostTypes.ConnectionState.class))));
        details = new StructType.FieldNameDetails("connection_states", "connectionStates", "getConnectionStates", "setConnectionStates");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new StructType("com.vmware.vcenter.host.filter_spec", fields, HostTypes.FilterSpec.class, validators, false, null, fieldNameDetails);
    }

    private static StructType summaryInit() {
        StructType.FieldNameDetails details = null;
        ArrayList<UnionValidator> validators = null;
        HashMap<String, List<UnionValidator.FieldData>> caseFields = null;
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("host", new IdType("HostSystem"));
        details = new StructType.FieldNameDetails("host", "host", "getHost", "setHost");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new StringType());
        details = new StructType.FieldNameDetails("name", "name", "getName", "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_state", new EnumType("com.vmware.vcenter.host.connection_state", HostTypes.ConnectionState.class));
        details = new StructType.FieldNameDetails("connection_state", "connectionState", "getConnectionState", "setConnectionState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("power_state", new OptionalType((Type)new EnumType("com.vmware.vcenter.host.power_state", HostTypes.PowerState.class)));
        details = new StructType.FieldNameDetails("power_state", "powerState", "getPowerState", "setPowerState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        validators = new ArrayList<UnionValidator>(1);
        caseFields = new HashMap<String, List<UnionValidator.FieldData>>();
        caseFields.put("CONNECTED", Arrays.asList(new UnionValidator.FieldData("power_state", false)));
        caseFields.put("DISCONNECTED", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("NOT_RESPONDING", Arrays.asList(new UnionValidator.FieldData[0]));
        validators.add(new UnionValidator("connection_state", caseFields));
        return new StructType("com.vmware.vcenter.host.summary", fields, HostTypes.Summary.class, validators, false, null, fieldNameDetails);
    }

    private static StructType __createInputInit() {
        List validators = null;
        HashMap<String, 2> fields = new HashMap<String, 2>();
        fields.put("spec", new TypeReference<StructType>(){

            public StructType resolve() {
                return createSpec;
            }
        });
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __createDefInit() {
        OperationDef operationDef = new OperationDef("create", "/vcenter/host", "POST", null, null);
        return operationDef;
    }

    private static StructType __deleteInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("host", new IdType("HostSystem"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __deleteDefInit() {
        OperationDef operationDef = new OperationDef("delete", "/vcenter/host/{host}", "DELETE", null, null);
        operationDef.registerPathVariable("host", "host");
        return operationDef;
    }

    private static StructType __listInputInit() {
        List validators = null;
        HashMap<String, OptionalType> fields = new HashMap<String, OptionalType>();
        fields.put("filter", new OptionalType((Type)new TypeReference<StructType>(){

            public StructType resolve() {
                return filterSpec;
            }
        }));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __listDefInit() {
        OperationDef operationDef = new OperationDef("list", "/vcenter/host", "GET", null, null);
        return operationDef;
    }

    private static StructType __connectInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("host", new IdType("HostSystem"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __connectDefInit() {
        OperationDef operationDef = new OperationDef("connect", "/vcenter/host/{host}/connect", "POST", null, null);
        operationDef.registerPathVariable("host", "host");
        return operationDef;
    }

    private static StructType __disconnectInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("host", new IdType("HostSystem"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __disconnectDefInit() {
        OperationDef operationDef = new OperationDef("disconnect", "/vcenter/host/{host}/disconnect", "POST", null, null);
        operationDef.registerPathVariable("host", "host");
        return operationDef;
    }
}

