/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.hvc.util;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vcenter.hvc.LinksDefinitions;
import com.vmware.vcenter.hvc.links.sync.ProvidersDefinitions;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.hvc.links.summary", LinksDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.hvc.links.create_spec", LinksDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.hvc.links.certificate_info", LinksDefinitions.certificateInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.hvc.links.sync.providers.info", ProvidersDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.hvc.links.sync.providers.session_info", ProvidersDefinitions.sessionInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.hvc.links.sync.providers.summary", ProvidersDefinitions.summary);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

