/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.vm.hardware;

import com.vmware.vapi.bindings.type.BooleanType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.IntegerType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.bindings.type.VoidType;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.OperationDef;
import com.vmware.vapi.internal.data.UnionValidator;
import com.vmware.vcenter.vm.hardware.ConnectionState;
import com.vmware.vcenter.vm.hardware.EthernetTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class EthernetDefinitions {
    public static final StructType backingInfo = EthernetDefinitions.backingInfoInit();
    public static final StructType backingSpec = EthernetDefinitions.backingSpecInit();
    public static final StructType info = EthernetDefinitions.infoInit();
    public static final StructType createSpec = EthernetDefinitions.createSpecInit();
    public static final StructType updateSpec = EthernetDefinitions.updateSpecInit();
    public static final StructType summary = EthernetDefinitions.summaryInit();
    public static final StructType __listInput = EthernetDefinitions.__listInputInit();
    public static final Type __listOutput = new ListType((Type)new TypeReference<StructType>(){

        public StructType resolve() {
            return summary;
        }
    });
    public static final OperationDef __listDef = EthernetDefinitions.__listDefInit();
    public static final StructType __getInput = EthernetDefinitions.__getInputInit();
    public static final Type __getOutput = new TypeReference<StructType>(){

        public StructType resolve() {
            return info;
        }
    };
    public static final OperationDef __getDef = EthernetDefinitions.__getDefInit();
    public static final StructType __createInput = EthernetDefinitions.__createInputInit();
    public static final Type __createOutput = new IdType("com.vmware.vcenter.vm.hardware.Ethernet");
    public static final OperationDef __createDef = EthernetDefinitions.__createDefInit();
    public static final StructType __updateInput = EthernetDefinitions.__updateInputInit();
    public static final Type __updateOutput = new VoidType();
    public static final OperationDef __updateDef = EthernetDefinitions.__updateDefInit();
    public static final StructType __deleteInput = EthernetDefinitions.__deleteInputInit();
    public static final Type __deleteOutput = new VoidType();
    public static final OperationDef __deleteDef = EthernetDefinitions.__deleteDefInit();
    public static final StructType __connectInput = EthernetDefinitions.__connectInputInit();
    public static final Type __connectOutput = new VoidType();
    public static final OperationDef __connectDef = EthernetDefinitions.__connectDefInit();
    public static final StructType __disconnectInput = EthernetDefinitions.__disconnectInputInit();
    public static final Type __disconnectOutput = new VoidType();
    public static final OperationDef __disconnectDef = EthernetDefinitions.__disconnectDefInit();
    public static final List<OperationDef> __operationDefs = Arrays.asList(__listDef, __getDef, __createDef, __updateDef, __deleteDef, __connectDef, __disconnectDef);

    private static StructType backingInfoInit() {
        StructType.FieldNameDetails details = null;
        ArrayList<UnionValidator> validators = null;
        HashMap<String, List<UnionValidator.FieldData>> caseFields = null;
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("type", new EnumType("com.vmware.vcenter.vm.hardware.ethernet.backing_type", EthernetTypes.BackingType.class));
        details = new StructType.FieldNameDetails("type", "type", "getType", "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("network", new OptionalType((Type)new IdType("Network")));
        details = new StructType.FieldNameDetails("network", "network", "getNetwork", "setNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("network_name", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("network_name", "networkName", "getNetworkName", "setNetworkName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_device", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("host_device", "hostDevice", "getHostDevice", "setHostDevice");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("distributed_switch_uuid", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("distributed_switch_uuid", "distributedSwitchUuid", "getDistributedSwitchUuid", "setDistributedSwitchUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("distributed_port", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("distributed_port", "distributedPort", "getDistributedPort", "setDistributedPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_cookie", new OptionalType((Type)new IntegerType()));
        details = new StructType.FieldNameDetails("connection_cookie", "connectionCookie", "getConnectionCookie", "setConnectionCookie");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("opaque_network_type", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("opaque_network_type", "opaqueNetworkType", "getOpaqueNetworkType", "setOpaqueNetworkType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("opaque_network_id", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("opaque_network_id", "opaqueNetworkId", "getOpaqueNetworkId", "setOpaqueNetworkId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        validators = new ArrayList<UnionValidator>(1);
        caseFields = new HashMap<String, List<UnionValidator.FieldData>>();
        caseFields.put("STANDARD_PORTGROUP", Arrays.asList(new UnionValidator.FieldData("network", true), new UnionValidator.FieldData("network_name", false)));
        caseFields.put("DISTRIBUTED_PORTGROUP", Arrays.asList(new UnionValidator.FieldData("network", true), new UnionValidator.FieldData("distributed_switch_uuid", false), new UnionValidator.FieldData("distributed_port", true), new UnionValidator.FieldData("connection_cookie", true)));
        caseFields.put("OPAQUE_NETWORK", Arrays.asList(new UnionValidator.FieldData("network", true), new UnionValidator.FieldData("opaque_network_type", false), new UnionValidator.FieldData("opaque_network_id", false)));
        caseFields.put("HOST_DEVICE", Arrays.asList(new UnionValidator.FieldData("host_device", false)));
        validators.add(new UnionValidator("type", caseFields));
        return new StructType("com.vmware.vcenter.vm.hardware.ethernet.backing_info", fields, EthernetTypes.BackingInfo.class, validators, false, null, fieldNameDetails);
    }

    private static StructType backingSpecInit() {
        StructType.FieldNameDetails details = null;
        ArrayList<UnionValidator> validators = null;
        HashMap<String, List<UnionValidator.FieldData>> caseFields = null;
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("type", new EnumType("com.vmware.vcenter.vm.hardware.ethernet.backing_type", EthernetTypes.BackingType.class));
        details = new StructType.FieldNameDetails("type", "type", "getType", "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("network", new OptionalType((Type)new IdType("Network")));
        details = new StructType.FieldNameDetails("network", "network", "getNetwork", "setNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("distributed_port", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("distributed_port", "distributedPort", "getDistributedPort", "setDistributedPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        validators = new ArrayList<UnionValidator>(1);
        caseFields = new HashMap<String, List<UnionValidator.FieldData>>();
        caseFields.put("STANDARD_PORTGROUP", Arrays.asList(new UnionValidator.FieldData("network", false)));
        caseFields.put("DISTRIBUTED_PORTGROUP", Arrays.asList(new UnionValidator.FieldData("network", false), new UnionValidator.FieldData("distributed_port", true)));
        caseFields.put("OPAQUE_NETWORK", Arrays.asList(new UnionValidator.FieldData("network", false)));
        caseFields.put("HOST_DEVICE", Arrays.asList(new UnionValidator.FieldData[0]));
        validators.add(new UnionValidator("type", caseFields));
        return new StructType("com.vmware.vcenter.vm.hardware.ethernet.backing_spec", fields, EthernetTypes.BackingSpec.class, validators, false, null, fieldNameDetails);
    }

    private static StructType infoInit() {
        StructType.FieldNameDetails details = null;
        ArrayList<UnionValidator> validators = null;
        HashMap<String, List<UnionValidator.FieldData>> caseFields = null;
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("label", new StringType());
        details = new StructType.FieldNameDetails("label", "label", "getLabel", "setLabel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new EnumType("com.vmware.vcenter.vm.hardware.ethernet.emulation_type", EthernetTypes.EmulationType.class));
        details = new StructType.FieldNameDetails("type", "type", "getType", "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("upt_compatibility_enabled", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("upt_compatibility_enabled", "uptCompatibilityEnabled", "getUptCompatibilityEnabled", "setUptCompatibilityEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_type", new EnumType("com.vmware.vcenter.vm.hardware.ethernet.mac_address_type", EthernetTypes.MacAddressType.class));
        details = new StructType.FieldNameDetails("mac_type", "macType", "getMacType", "setMacType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_address", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("mac_address", "macAddress", "getMacAddress", "setMacAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pci_slot_number", new OptionalType((Type)new IntegerType()));
        details = new StructType.FieldNameDetails("pci_slot_number", "pciSlotNumber", "getPciSlotNumber", "setPciSlotNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("wake_on_lan_enabled", new BooleanType());
        details = new StructType.FieldNameDetails("wake_on_lan_enabled", "wakeOnLanEnabled", "getWakeOnLanEnabled", "setWakeOnLanEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("backing", new TypeReference<StructType>(){

            public StructType resolve() {
                return backingInfo;
            }
        });
        details = new StructType.FieldNameDetails("backing", "backing", "getBacking", "setBacking");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("state", new EnumType("com.vmware.vcenter.vm.hardware.connection_state", ConnectionState.class));
        details = new StructType.FieldNameDetails("state", "state", "getState", "setState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("start_connected", new BooleanType());
        details = new StructType.FieldNameDetails("start_connected", "startConnected", "getStartConnected", "setStartConnected");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allow_guest_control", new BooleanType());
        details = new StructType.FieldNameDetails("allow_guest_control", "allowGuestControl", "getAllowGuestControl", "setAllowGuestControl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        validators = new ArrayList<UnionValidator>(1);
        caseFields = new HashMap<String, List<UnionValidator.FieldData>>();
        caseFields.put("VMXNET3", Arrays.asList(new UnionValidator.FieldData("upt_compatibility_enabled", false)));
        caseFields.put("E1000", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("E1000E", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("PCNET32", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("VMXNET", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("VMXNET2", Arrays.asList(new UnionValidator.FieldData[0]));
        validators.add(new UnionValidator("type", caseFields));
        return new StructType("com.vmware.vcenter.vm.hardware.ethernet.info", fields, EthernetTypes.Info.class, validators, false, null, fieldNameDetails);
    }

    private static StructType createSpecInit() {
        StructType.FieldNameDetails details = null;
        ArrayList<UnionValidator> validators = null;
        HashMap<String, List<UnionValidator.FieldData>> caseFields = null;
        LinkedHashMap<String, OptionalType> fields = new LinkedHashMap<String, OptionalType>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("type", new OptionalType((Type)new EnumType("com.vmware.vcenter.vm.hardware.ethernet.emulation_type", EthernetTypes.EmulationType.class)));
        details = new StructType.FieldNameDetails("type", "type", "getType", "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("upt_compatibility_enabled", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("upt_compatibility_enabled", "uptCompatibilityEnabled", "getUptCompatibilityEnabled", "setUptCompatibilityEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_type", new OptionalType((Type)new EnumType("com.vmware.vcenter.vm.hardware.ethernet.mac_address_type", EthernetTypes.MacAddressType.class)));
        details = new StructType.FieldNameDetails("mac_type", "macType", "getMacType", "setMacType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_address", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("mac_address", "macAddress", "getMacAddress", "setMacAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pci_slot_number", new OptionalType((Type)new IntegerType()));
        details = new StructType.FieldNameDetails("pci_slot_number", "pciSlotNumber", "getPciSlotNumber", "setPciSlotNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("wake_on_lan_enabled", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("wake_on_lan_enabled", "wakeOnLanEnabled", "getWakeOnLanEnabled", "setWakeOnLanEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("backing", new OptionalType((Type)new TypeReference<StructType>(){

            public StructType resolve() {
                return backingSpec;
            }
        }));
        details = new StructType.FieldNameDetails("backing", "backing", "getBacking", "setBacking");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("start_connected", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("start_connected", "startConnected", "getStartConnected", "setStartConnected");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allow_guest_control", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("allow_guest_control", "allowGuestControl", "getAllowGuestControl", "setAllowGuestControl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        validators = new ArrayList<UnionValidator>(2);
        caseFields = new HashMap<String, List<UnionValidator.FieldData>>();
        caseFields.put("VMXNET3", Arrays.asList(new UnionValidator.FieldData("upt_compatibility_enabled", true)));
        caseFields.put("E1000", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("E1000E", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("PCNET32", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("VMXNET", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("VMXNET2", Arrays.asList(new UnionValidator.FieldData[0]));
        validators.add(new UnionValidator("type", caseFields));
        caseFields = new HashMap();
        caseFields.put("MANUAL", Arrays.asList(new UnionValidator.FieldData("mac_address", false)));
        caseFields.put("GENERATED", Arrays.asList(new UnionValidator.FieldData[0]));
        caseFields.put("ASSIGNED", Arrays.asList(new UnionValidator.FieldData[0]));
        validators.add(new UnionValidator("mac_type", caseFields));
        return new StructType("com.vmware.vcenter.vm.hardware.ethernet.create_spec", fields, EthernetTypes.CreateSpec.class, validators, false, null, fieldNameDetails);
    }

    private static StructType updateSpecInit() {
        StructType.FieldNameDetails details = null;
        List validators = null;
        LinkedHashMap<String, OptionalType> fields = new LinkedHashMap<String, OptionalType>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("upt_compatibility_enabled", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("upt_compatibility_enabled", "uptCompatibilityEnabled", "getUptCompatibilityEnabled", "setUptCompatibilityEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_type", new OptionalType((Type)new EnumType("com.vmware.vcenter.vm.hardware.ethernet.mac_address_type", EthernetTypes.MacAddressType.class)));
        details = new StructType.FieldNameDetails("mac_type", "macType", "getMacType", "setMacType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_address", new OptionalType((Type)new StringType()));
        details = new StructType.FieldNameDetails("mac_address", "macAddress", "getMacAddress", "setMacAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("wake_on_lan_enabled", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("wake_on_lan_enabled", "wakeOnLanEnabled", "getWakeOnLanEnabled", "setWakeOnLanEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("backing", new OptionalType((Type)new TypeReference<StructType>(){

            public StructType resolve() {
                return backingSpec;
            }
        }));
        details = new StructType.FieldNameDetails("backing", "backing", "getBacking", "setBacking");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("start_connected", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("start_connected", "startConnected", "getStartConnected", "setStartConnected");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allow_guest_control", new OptionalType((Type)new BooleanType()));
        details = new StructType.FieldNameDetails("allow_guest_control", "allowGuestControl", "getAllowGuestControl", "setAllowGuestControl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new StructType("com.vmware.vcenter.vm.hardware.ethernet.update_spec", fields, EthernetTypes.UpdateSpec.class, validators, false, null, fieldNameDetails);
    }

    private static StructType summaryInit() {
        StructType.FieldNameDetails details = null;
        List validators = null;
        LinkedHashMap<String, IdType> fields = new LinkedHashMap<String, IdType>();
        HashMap<String, StructType.FieldNameDetails> fieldNameDetails = new HashMap<String, StructType.FieldNameDetails>();
        fields.put("nic", new IdType("com.vmware.vcenter.vm.hardware.Ethernet"));
        details = new StructType.FieldNameDetails("nic", "nic", "getNic", "setNic");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new StructType("com.vmware.vcenter.vm.hardware.ethernet.summary", fields, EthernetTypes.Summary.class, validators, false, null, fieldNameDetails);
    }

    private static StructType __listInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("vm", new IdType("VirtualMachine"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __listDefInit() {
        OperationDef operationDef = new OperationDef("list", "/vcenter/vm/{vm}/hardware/ethernet", "GET", null, null);
        operationDef.registerPathVariable("vm", "vm");
        return operationDef;
    }

    private static StructType __getInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("vm", new IdType("VirtualMachine"));
        fields.put("nic", new IdType("com.vmware.vcenter.vm.hardware.Ethernet"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __getDefInit() {
        OperationDef operationDef = new OperationDef("get", "/vcenter/vm/{vm}/hardware/ethernet/{nic}", "GET", null, null);
        operationDef.registerPathVariable("vm", "vm");
        operationDef.registerPathVariable("nic", "nic");
        return operationDef;
    }

    private static StructType __createInputInit() {
        List validators = null;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("vm", new IdType("VirtualMachine"));
        fields.put("spec", new TypeReference<StructType>(){

            public StructType resolve() {
                return createSpec;
            }
        });
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __createDefInit() {
        OperationDef operationDef = new OperationDef("create", "/vcenter/vm/{vm}/hardware/ethernet", "POST", null, null);
        operationDef.registerPathVariable("vm", "vm");
        return operationDef;
    }

    private static StructType __updateInputInit() {
        List validators = null;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("vm", new IdType("VirtualMachine"));
        fields.put("nic", new IdType("com.vmware.vcenter.vm.hardware.Ethernet"));
        fields.put("spec", new TypeReference<StructType>(){

            public StructType resolve() {
                return updateSpec;
            }
        });
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __updateDefInit() {
        OperationDef operationDef = new OperationDef("update", "/vcenter/vm/{vm}/hardware/ethernet/{nic}", "PATCH", null, null);
        operationDef.registerPathVariable("vm", "vm");
        operationDef.registerPathVariable("nic", "nic");
        return operationDef;
    }

    private static StructType __deleteInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("vm", new IdType("VirtualMachine"));
        fields.put("nic", new IdType("com.vmware.vcenter.vm.hardware.Ethernet"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __deleteDefInit() {
        OperationDef operationDef = new OperationDef("delete", "/vcenter/vm/{vm}/hardware/ethernet/{nic}", "DELETE", null, null);
        operationDef.registerPathVariable("vm", "vm");
        operationDef.registerPathVariable("nic", "nic");
        return operationDef;
    }

    private static StructType __connectInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("vm", new IdType("VirtualMachine"));
        fields.put("nic", new IdType("com.vmware.vcenter.vm.hardware.Ethernet"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __connectDefInit() {
        OperationDef operationDef = new OperationDef("connect", "/vcenter/vm/{vm}/hardware/ethernet/{nic}/connect", "POST", null, null);
        operationDef.registerPathVariable("vm", "vm");
        operationDef.registerPathVariable("nic", "nic");
        return operationDef;
    }

    private static StructType __disconnectInputInit() {
        List validators = null;
        HashMap<String, IdType> fields = new HashMap<String, IdType>();
        fields.put("vm", new IdType("VirtualMachine"));
        fields.put("nic", new IdType("com.vmware.vcenter.vm.hardware.Ethernet"));
        return new StructType("operation-input", fields, StructValue.class, validators, false, null, null);
    }

    private static OperationDef __disconnectDefInit() {
        OperationDef operationDef = new OperationDef("disconnect", "/vcenter/vm/{vm}/hardware/ethernet/{nic}/disconnect", "POST", null, null);
        operationDef.registerPathVariable("vm", "vm");
        operationDef.registerPathVariable("nic", "nic");
        return operationDef;
    }
}

