/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.wdullaer.materialdatetimepicker.HapticFeedbackController;
import com.wdullaer.materialdatetimepicker.R;
import com.wdullaer.materialdatetimepicker.TypefaceHelper;
import com.wdullaer.materialdatetimepicker.Utils;
import com.wdullaer.materialdatetimepicker.date.AccessibleDateAnimator;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.DayPickerView;
import com.wdullaer.materialdatetimepicker.date.MonthAdapter;
import com.wdullaer.materialdatetimepicker.date.SimpleDayPickerView;
import com.wdullaer.materialdatetimepicker.date.YearPickerView;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;

public class DatePickerDialog
extends DialogFragment
implements View.OnClickListener,
DatePickerController {
    private static final String TAG = "DatePickerDialog";
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_LIST_POSITION = "list_position";
    private static final String KEY_WEEK_START = "week_start";
    private static final String KEY_YEAR_START = "year_start";
    private static final String KEY_YEAR_END = "year_end";
    private static final String KEY_CURRENT_VIEW = "current_view";
    private static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static final String KEY_MIN_DATE = "min_date";
    private static final String KEY_MAX_DATE = "max_date";
    private static final String KEY_HIGHLIGHTED_DAYS = "highlighted_days";
    private static final String KEY_SELECTABLE_DAYS = "selectable_days";
    private static final String KEY_DISABLED_DAYS = "disabled_days";
    private static final String KEY_THEME_DARK = "theme_dark";
    private static final String KEY_THEME_DARK_CHANGED = "theme_dark_changed";
    private static final String KEY_ACCENT = "accent";
    private static final String KEY_VIBRATE = "vibrate";
    private static final String KEY_DISMISS = "dismiss";
    private static final String KEY_AUTO_DISMISS = "auto_dismiss";
    private static final String KEY_DEFAULT_VIEW = "default_view";
    private static final String KEY_TITLE = "title";
    private static final String KEY_OK_RESID = "ok_resid";
    private static final String KEY_OK_STRING = "ok_string";
    private static final String KEY_CANCEL_RESID = "cancel_resid";
    private static final String KEY_CANCEL_STRING = "cancel_string";
    private static final String KEY_VERSION = "version";
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int ANIMATION_DURATION = 300;
    private static final int ANIMATION_DELAY = 500;
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private static SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("MMM", Locale.getDefault());
    private static SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private static SimpleDateFormat VERSION_2_FORMAT;
    private final Calendar mCalendar = this.trimToMidnight(Calendar.getInstance());
    private OnDateSetListener mCallBack;
    private HashSet<OnDateChangedListener> mListeners = new HashSet();
    private DialogInterface.OnCancelListener mOnCancelListener;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private AccessibleDateAnimator mAnimator;
    private TextView mDatePickerHeaderView;
    private LinearLayout mMonthAndDayView;
    private TextView mSelectedMonthTextView;
    private TextView mSelectedDayTextView;
    private TextView mYearView;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private int mCurrentView = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private int mMinYear = 1900;
    private int mMaxYear = 2100;
    private String mTitle;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar[] highlightedDays;
    private Calendar[] selectableDays;
    private Calendar[] disabledDays;
    private boolean mThemeDark = false;
    private boolean mThemeDarkChanged = false;
    private int mAccentColor = -1;
    private boolean mVibrate = true;
    private boolean mDismissOnPause = false;
    private boolean mAutoDismiss = false;
    private int mDefaultView = 0;
    private int mOkResid = R.string.mdtp_ok;
    private String mOkString;
    private int mCancelResid = R.string.mdtp_cancel;
    private String mCancelString;
    private Version mVersion;
    private HapticFeedbackController mHapticFeedbackController;
    private boolean mDelayAnimation = true;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mYearPickerDescription;
    private String mSelectYear;

    public static DatePickerDialog newInstance(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        DatePickerDialog ret = new DatePickerDialog();
        ret.initialize(callBack, year, monthOfYear, dayOfMonth);
        return ret;
    }

    public void initialize(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
        this.mCalendar.set(5, dayOfMonth);
        this.mVersion = Build.VERSION.SDK_INT < 23 ? Version.VERSION_1 : Version.VERSION_2;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Activity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mCurrentView = -1;
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, savedInstanceState.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, savedInstanceState.getInt(KEY_SELECTED_DAY));
            this.mDefaultView = savedInstanceState.getInt(KEY_DEFAULT_VIEW);
        }
        VERSION_2_FORMAT = Build.VERSION.SDK_INT < 18 ? new SimpleDateFormat(activity.getResources().getString(R.string.mdtp_date_v2_daymonthyear), Locale.getDefault()) : new SimpleDateFormat(DateFormat.getBestDateTimePattern((Locale)Locale.getDefault(), (String)"EEEMMMdd"), Locale.getDefault());
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        outState.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        outState.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        outState.putInt(KEY_WEEK_START, this.mWeekStart);
        outState.putInt(KEY_YEAR_START, this.mMinYear);
        outState.putInt(KEY_YEAR_END, this.mMaxYear);
        outState.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
        }
        outState.putInt(KEY_LIST_POSITION, listPosition);
        outState.putSerializable(KEY_MIN_DATE, (Serializable)this.mMinDate);
        outState.putSerializable(KEY_MAX_DATE, (Serializable)this.mMaxDate);
        outState.putSerializable(KEY_HIGHLIGHTED_DAYS, (Serializable)this.highlightedDays);
        outState.putSerializable(KEY_SELECTABLE_DAYS, (Serializable)this.selectableDays);
        outState.putSerializable(KEY_DISABLED_DAYS, (Serializable)this.disabledDays);
        outState.putBoolean(KEY_THEME_DARK, this.mThemeDark);
        outState.putBoolean(KEY_THEME_DARK_CHANGED, this.mThemeDarkChanged);
        outState.putInt(KEY_ACCENT, this.mAccentColor);
        outState.putBoolean(KEY_VIBRATE, this.mVibrate);
        outState.putBoolean(KEY_DISMISS, this.mDismissOnPause);
        outState.putBoolean(KEY_AUTO_DISMISS, this.mAutoDismiss);
        outState.putInt(KEY_DEFAULT_VIEW, this.mDefaultView);
        outState.putString(KEY_TITLE, this.mTitle);
        outState.putInt(KEY_OK_RESID, this.mOkResid);
        outState.putString(KEY_OK_STRING, this.mOkString);
        outState.putInt(KEY_CANCEL_RESID, this.mCancelResid);
        outState.putString(KEY_CANCEL_STRING, this.mCancelString);
        outState.putSerializable(KEY_VERSION, (Serializable)((Object)this.mVersion));
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = this.mDefaultView;
        if (savedInstanceState != null) {
            this.mWeekStart = savedInstanceState.getInt(KEY_WEEK_START);
            this.mMinYear = savedInstanceState.getInt(KEY_YEAR_START);
            this.mMaxYear = savedInstanceState.getInt(KEY_YEAR_END);
            currentView = savedInstanceState.getInt(KEY_CURRENT_VIEW);
            listPosition = savedInstanceState.getInt(KEY_LIST_POSITION);
            listPositionOffset = savedInstanceState.getInt(KEY_LIST_POSITION_OFFSET);
            this.mMinDate = (Calendar)savedInstanceState.getSerializable(KEY_MIN_DATE);
            this.mMaxDate = (Calendar)savedInstanceState.getSerializable(KEY_MAX_DATE);
            this.highlightedDays = (Calendar[])savedInstanceState.getSerializable(KEY_HIGHLIGHTED_DAYS);
            this.selectableDays = (Calendar[])savedInstanceState.getSerializable(KEY_SELECTABLE_DAYS);
            this.disabledDays = (Calendar[])savedInstanceState.getSerializable(KEY_DISABLED_DAYS);
            this.mThemeDark = savedInstanceState.getBoolean(KEY_THEME_DARK);
            this.mThemeDarkChanged = savedInstanceState.getBoolean(KEY_THEME_DARK_CHANGED);
            this.mAccentColor = savedInstanceState.getInt(KEY_ACCENT);
            this.mVibrate = savedInstanceState.getBoolean(KEY_VIBRATE);
            this.mDismissOnPause = savedInstanceState.getBoolean(KEY_DISMISS);
            this.mAutoDismiss = savedInstanceState.getBoolean(KEY_AUTO_DISMISS);
            this.mTitle = savedInstanceState.getString(KEY_TITLE);
            this.mOkResid = savedInstanceState.getInt(KEY_OK_RESID);
            this.mOkString = savedInstanceState.getString(KEY_OK_STRING);
            this.mCancelResid = savedInstanceState.getInt(KEY_CANCEL_RESID);
            this.mCancelString = savedInstanceState.getString(KEY_CANCEL_STRING);
            this.mVersion = (Version)((Object)savedInstanceState.getSerializable(KEY_VERSION));
        }
        int viewRes = this.mVersion == Version.VERSION_1 ? R.layout.mdtp_date_picker_dialog : R.layout.mdtp_date_picker_dialog_v2;
        View view = inflater.inflate(viewRes, container, false);
        this.setToNearestDate(this.mCalendar);
        this.mDatePickerHeaderView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mMonthAndDayView = (LinearLayout)view.findViewById(R.id.date_picker_month_and_day);
        this.mMonthAndDayView.setOnClickListener((View.OnClickListener)this);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.date_picker_month);
        this.mSelectedDayTextView = (TextView)view.findViewById(R.id.date_picker_day);
        this.mYearView = (TextView)view.findViewById(R.id.date_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        Activity activity = this.getActivity();
        this.mDayPickerView = new SimpleDayPickerView((Context)activity, this);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        if (!this.mThemeDarkChanged) {
            this.mThemeDark = Utils.isDarkTheme((Context)activity, this.mThemeDark);
        }
        Resources res = this.getResources();
        this.mDayPickerDescription = res.getString(R.string.mdtp_day_picker_description);
        this.mSelectDay = res.getString(R.string.mdtp_select_day);
        this.mYearPickerDescription = res.getString(R.string.mdtp_year_picker_description);
        this.mSelectYear = res.getString(R.string.mdtp_select_year);
        int bgColorResource = this.mThemeDark ? R.color.mdtp_date_picker_view_animator_dark_theme : R.color.mdtp_date_picker_view_animator;
        view.setBackgroundColor(ContextCompat.getColor((Context)activity, (int)bgColorResource));
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        Button okButton = (Button)view.findViewById(R.id.ok);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                DatePickerDialog.this.notifyOnDateListener();
                DatePickerDialog.this.dismiss();
            }
        });
        okButton.setTypeface(TypefaceHelper.get((Context)activity, "Roboto-Medium"));
        if (this.mOkString != null) {
            okButton.setText((CharSequence)this.mOkString);
        } else {
            okButton.setText(this.mOkResid);
        }
        Button cancelButton = (Button)view.findViewById(R.id.cancel);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                if (DatePickerDialog.this.getDialog() != null) {
                    DatePickerDialog.this.getDialog().cancel();
                }
            }
        });
        cancelButton.setTypeface(TypefaceHelper.get((Context)activity, "Roboto-Medium"));
        if (this.mCancelString != null) {
            cancelButton.setText((CharSequence)this.mCancelString);
        } else {
            cancelButton.setText(this.mCancelResid);
        }
        cancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        if (this.mAccentColor == -1) {
            this.mAccentColor = Utils.getAccentColorFromThemeIfAvailable((Context)this.getActivity());
        }
        if (this.mDatePickerHeaderView != null) {
            this.mDatePickerHeaderView.setBackgroundColor(Utils.darkenColor(this.mAccentColor));
        }
        view.findViewById(R.id.day_picker_selected_date_layout).setBackgroundColor(this.mAccentColor);
        okButton.setTextColor(this.mAccentColor);
        cancelButton.setTextColor(this.mAccentColor);
        if (this.getDialog() == null) {
            view.findViewById(R.id.done_background).setVisibility(8);
        }
        this.updateDisplay(false);
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        return view;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ViewGroup viewGroup = (ViewGroup)this.getView();
        if (viewGroup != null) {
            viewGroup.removeAllViewsInLayout();
            View view = this.onCreateView(this.getActivity().getLayoutInflater(), viewGroup, null);
            viewGroup.addView(view);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
        if (this.mDismissOnPause) {
            this.dismiss();
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (this.mOnCancelListener != null) {
            this.mOnCancelListener.onCancel(dialog);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    private void setCurrentView(int viewIndex) {
        long millis = this.mCalendar.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                if (this.mVersion == Version.VERSION_1) {
                    ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mMonthAndDayView, 0.9f, 1.05f);
                    if (this.mDelayAnimation) {
                        pulseAnimator.setStartDelay(500L);
                        this.mDelayAnimation = false;
                    }
                    this.mDayPickerView.onDateChanged();
                    if (this.mCurrentView != viewIndex) {
                        this.mMonthAndDayView.setSelected(true);
                        this.mYearView.setSelected(false);
                        this.mAnimator.setDisplayedChild(0);
                        this.mCurrentView = viewIndex;
                    }
                    pulseAnimator.start();
                } else {
                    this.mDayPickerView.onDateChanged();
                    if (this.mCurrentView != viewIndex) {
                        this.mMonthAndDayView.setSelected(true);
                        this.mYearView.setSelected(false);
                        this.mAnimator.setDisplayedChild(0);
                        this.mCurrentView = viewIndex;
                    }
                }
                int flags = 16;
                String dayString = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 1: {
                if (this.mVersion == Version.VERSION_1) {
                    ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                    if (this.mDelayAnimation) {
                        pulseAnimator.setStartDelay(500L);
                        this.mDelayAnimation = false;
                    }
                    this.mYearPickerView.onDateChanged();
                    if (this.mCurrentView != viewIndex) {
                        this.mMonthAndDayView.setSelected(false);
                        this.mYearView.setSelected(true);
                        this.mAnimator.setDisplayedChild(1);
                        this.mCurrentView = viewIndex;
                    }
                    pulseAnimator.start();
                } else {
                    this.mYearPickerView.onDateChanged();
                    if (this.mCurrentView != viewIndex) {
                        this.mMonthAndDayView.setSelected(false);
                        this.mYearView.setSelected(true);
                        this.mAnimator.setDisplayedChild(1);
                        this.mCurrentView = viewIndex;
                    }
                }
                String yearString = YEAR_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectYear);
            }
        }
    }

    private void updateDisplay(boolean announce) {
        this.mYearView.setText((CharSequence)YEAR_FORMAT.format(this.mCalendar.getTime()));
        if (this.mVersion == Version.VERSION_1) {
            if (this.mDatePickerHeaderView != null) {
                if (this.mTitle != null) {
                    this.mDatePickerHeaderView.setText((CharSequence)this.mTitle.toUpperCase(Locale.getDefault()));
                } else {
                    this.mDatePickerHeaderView.setText((CharSequence)this.mCalendar.getDisplayName(7, 2, Locale.getDefault()).toUpperCase(Locale.getDefault()));
                }
            }
            this.mSelectedMonthTextView.setText((CharSequence)MONTH_FORMAT.format(this.mCalendar.getTime()));
            this.mSelectedDayTextView.setText((CharSequence)DAY_FORMAT.format(this.mCalendar.getTime()));
        }
        if (this.mVersion == Version.VERSION_2) {
            this.mSelectedDayTextView.setText((CharSequence)VERSION_2_FORMAT.format(this.mCalendar.getTime()));
            if (this.mTitle != null) {
                this.mDatePickerHeaderView.setText((CharSequence)this.mTitle.toUpperCase(Locale.getDefault()));
            } else {
                this.mDatePickerHeaderView.setVisibility(8);
            }
        }
        long millis = this.mCalendar.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
        this.mMonthAndDayView.setContentDescription((CharSequence)monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
        }
    }

    public void vibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    public void dismissOnPause(boolean dismissOnPause) {
        this.mDismissOnPause = dismissOnPause;
    }

    public void autoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
    }

    public void setThemeDark(boolean themeDark) {
        this.mThemeDark = themeDark;
        this.mThemeDarkChanged = true;
    }

    @Override
    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    public void setAccentColor(String color2) {
        this.mAccentColor = Color.parseColor((String)color2);
    }

    public void setAccentColor(@ColorInt int color2) {
        this.mAccentColor = Color.argb((int)255, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    @Override
    public int getAccentColor() {
        return this.mAccentColor;
    }

    public void showYearPickerFirst(boolean yearPicker) {
        this.mDefaultView = yearPicker ? 1 : 0;
    }

    public void setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear < startYear) {
            throw new IllegalArgumentException("Year end must be larger than or equal to year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = this.trimToMidnight(calendar);
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = this.trimToMidnight(calendar);
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setHighlightedDays(Calendar[] highlightedDays) {
        Arrays.sort(highlightedDays);
        for (Calendar highlightedDay : highlightedDays) {
            this.trimToMidnight(highlightedDay);
        }
        this.highlightedDays = highlightedDays;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    @Override
    public Calendar[] getHighlightedDays() {
        return this.highlightedDays;
    }

    public void setSelectableDays(Calendar[] selectableDays) {
        Arrays.sort(selectableDays);
        for (Calendar selectableDay : selectableDays) {
            this.trimToMidnight(selectableDay);
        }
        this.selectableDays = selectableDays;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar[] getSelectableDays() {
        return this.selectableDays;
    }

    public void setDisabledDays(Calendar[] disabledDays) {
        Arrays.sort(disabledDays);
        for (Calendar disabledDay : disabledDays) {
            this.trimToMidnight(disabledDay);
        }
        this.disabledDays = disabledDays;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar[] getDisabledDays() {
        return this.disabledDays;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setOkText(String okString) {
        this.mOkString = okString;
    }

    public void setOkText(@StringRes int okResid) {
        this.mOkString = null;
        this.mOkResid = okResid;
    }

    public void setCancelText(String cancelString) {
        this.mCancelString = cancelString;
    }

    public void setCancelText(@StringRes int cancelResid) {
        this.mCancelString = null;
        this.mCancelResid = cancelResid;
    }

    public void setVersion(Version version) {
        this.mVersion = version;
    }

    public void setOnDateSetListener(OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mOnCancelListener = onCancelListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private void adjustDayInMonthIfNeeded(Calendar calendar) {
        int daysInMonth;
        int day = calendar.get(5);
        if (day > (daysInMonth = calendar.getActualMaximum(5))) {
            calendar.set(5, daysInMonth);
        }
        this.setToNearestDate(calendar);
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.date_picker_year) {
            this.setCurrentView(1);
        } else if (v.getId() == R.id.date_picker_month_and_day) {
            this.setCurrentView(0);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.mCalendar.set(1, year);
        this.adjustDayInMonthIfNeeded(this.mCalendar);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
        if (this.mAutoDismiss) {
            this.notifyOnDateListener();
            this.dismiss();
        }
    }

    private void updatePickers() {
        for (OnDateChangedListener listener : this.mListeners) {
            listener.onDateChanged();
        }
    }

    @Override
    public MonthAdapter.CalendarDay getSelectedDay() {
        return new MonthAdapter.CalendarDay(this.mCalendar);
    }

    @Override
    public Calendar getStartDate() {
        if (this.selectableDays != null) {
            return this.selectableDays[0];
        }
        if (this.mMinDate != null) {
            return this.mMinDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMinYear);
        output.set(5, 1);
        output.set(2, 0);
        return output;
    }

    @Override
    public Calendar getEndDate() {
        if (this.selectableDays != null) {
            return this.selectableDays[this.selectableDays.length - 1];
        }
        if (this.mMaxDate != null) {
            return this.mMaxDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMaxYear);
        output.set(5, 31);
        output.set(2, 11);
        return output;
    }

    @Override
    public int getMinYear() {
        if (this.selectableDays != null) {
            return this.selectableDays[0].get(1);
        }
        return this.mMinDate != null && this.mMinDate.get(1) > this.mMinYear ? this.mMinDate.get(1) : this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        if (this.selectableDays != null) {
            return this.selectableDays[this.selectableDays.length - 1].get(1);
        }
        return this.mMaxDate != null && this.mMaxDate.get(1) < this.mMaxYear ? this.mMaxDate.get(1) : this.mMaxYear;
    }

    @Override
    public boolean isOutOfRange(int year, int month, int day) {
        return this.isDisabled(year, month, day) || !this.isSelectable(year, month, day);
    }

    public boolean isOutOfRange(Calendar calendar) {
        return this.isOutOfRange(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private boolean isDisabled(int year, int month, int day) {
        return this.containsDate(this.disabledDays, year, month, day) || this.isBeforeMin(year, month, day) || this.isAfterMax(year, month, day);
    }

    private boolean isDisabled(Calendar c) {
        return this.isDisabled(c.get(1), c.get(2), c.get(5));
    }

    private boolean isSelectable(int year, int month, int day) {
        return this.selectableDays == null || this.containsDate(this.selectableDays, year, month, day);
    }

    private boolean containsDate(Calendar[] dates, int year, int month, int day) {
        if (dates == null) {
            return false;
        }
        for (Calendar c : dates) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            if (month < c.get(2)) break;
            if (month > c.get(2)) continue;
            if (day < c.get(5)) break;
            if (day > c.get(5)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeforeMin(int year, int month, int day) {
        if (this.mMinDate == null) {
            return false;
        }
        if (year < this.mMinDate.get(1)) {
            return true;
        }
        if (year > this.mMinDate.get(1)) {
            return false;
        }
        if (month < this.mMinDate.get(2)) {
            return true;
        }
        if (month > this.mMinDate.get(2)) {
            return false;
        }
        return day < this.mMinDate.get(5);
    }

    private boolean isBeforeMin(Calendar calendar) {
        return this.isBeforeMin(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private boolean isAfterMax(int year, int month, int day) {
        if (this.mMaxDate == null) {
            return false;
        }
        if (year > this.mMaxDate.get(1)) {
            return true;
        }
        if (year < this.mMaxDate.get(1)) {
            return false;
        }
        if (month > this.mMaxDate.get(2)) {
            return true;
        }
        if (month < this.mMaxDate.get(2)) {
            return false;
        }
        return day > this.mMaxDate.get(5);
    }

    private boolean isAfterMax(Calendar calendar) {
        return this.isAfterMax(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private void setToNearestDate(Calendar calendar) {
        if (this.selectableDays != null) {
            long distance = Long.MAX_VALUE;
            Calendar currentBest = calendar;
            for (Calendar c : this.selectableDays) {
                long newDistance = Math.abs(calendar.getTimeInMillis() - c.getTimeInMillis());
                if (newDistance >= distance || this.isDisabled(c)) break;
                distance = newDistance;
                currentBest = c;
            }
            calendar.setTimeInMillis(currentBest.getTimeInMillis());
            return;
        }
        if (this.disabledDays != null) {
            Calendar forwardDate = (Calendar)calendar.clone();
            Calendar backwardDate = (Calendar)calendar.clone();
            while (this.isDisabled(forwardDate) && this.isDisabled(backwardDate)) {
                forwardDate.add(5, 1);
                backwardDate.add(5, -1);
            }
            if (!this.isDisabled(backwardDate)) {
                calendar.setTimeInMillis(backwardDate.getTimeInMillis());
                return;
            }
            if (!this.isDisabled(forwardDate)) {
                calendar.setTimeInMillis(forwardDate.getTimeInMillis());
                return;
            }
        }
        if (this.isBeforeMin(calendar)) {
            calendar.setTimeInMillis(this.mMinDate.getTimeInMillis());
            return;
        }
        if (this.isAfterMax(calendar)) {
            calendar.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            return;
        }
    }

    private Calendar trimToMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void tryVibrate() {
        if (this.mVibrate) {
            this.mHapticFeedbackController.tryVibrate();
        }
    }

    public void notifyOnDateListener() {
        if (this.mCallBack != null) {
            this.mCallBack.onDateSet(this, this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged();
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePickerDialog var1, int var2, int var3, int var4);
    }

    public static enum Version {
        VERSION_1,
        VERSION_2;

    }
}

