/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import com.wdullaer.materialdatetimepicker.R;
import com.wdullaer.materialdatetimepicker.time.AmPmCirclesView;
import com.wdullaer.materialdatetimepicker.time.CircleView;
import com.wdullaer.materialdatetimepicker.time.RadialSelectorView;
import com.wdullaer.materialdatetimepicker.time.RadialTextsView;
import com.wdullaer.materialdatetimepicker.time.TimePickerController;
import com.wdullaer.materialdatetimepicker.time.TimePickerDialog;
import com.wdullaer.materialdatetimepicker.time.Timepoint;
import java.util.Calendar;
import java.util.Locale;

public class RadialPickerLayout
extends FrameLayout
implements View.OnTouchListener {
    private static final String TAG = "RadialPickerLayout";
    private final int TOUCH_SLOP;
    private final int TAP_TIMEOUT;
    private static final int VISIBLE_DEGREES_STEP_SIZE = 30;
    private static final int HOUR_VALUE_TO_DEGREES_STEP_SIZE = 30;
    private static final int MINUTE_VALUE_TO_DEGREES_STEP_SIZE = 6;
    private static final int SECOND_VALUE_TO_DEGREES_STEP_SIZE = 6;
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int SECOND_INDEX = 2;
    private static final int AM = 0;
    private static final int PM = 1;
    private Timepoint mLastValueSelected;
    private TimePickerController mController;
    private OnValueSelectedListener mListener;
    private boolean mTimeInitialized;
    private Timepoint mCurrentTime;
    private boolean mIs24HourMode;
    private int mCurrentItemShowing;
    private CircleView mCircleView;
    private AmPmCirclesView mAmPmCirclesView;
    private RadialTextsView mHourRadialTextsView;
    private RadialTextsView mMinuteRadialTextsView;
    private RadialTextsView mSecondRadialTextsView;
    private RadialSelectorView mHourRadialSelectorView;
    private RadialSelectorView mMinuteRadialSelectorView;
    private RadialSelectorView mSecondRadialSelectorView;
    private View mGrayBox;
    private int[] mSnapPrefer30sMap;
    private boolean mInputEnabled;
    private int mIsTouchingAmOrPm = -1;
    private boolean mDoingMove;
    private boolean mDoingTouch;
    private int mDownDegrees;
    private float mDownX;
    private float mDownY;
    private AccessibilityManager mAccessibilityManager;
    private AnimatorSet mTransition;
    private Handler mHandler = new Handler();

    public RadialPickerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnTouchListener(this);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.TOUCH_SLOP = vc.getScaledTouchSlop();
        this.TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        this.mDoingMove = false;
        this.mCircleView = new CircleView(context);
        this.addView(this.mCircleView);
        this.mAmPmCirclesView = new AmPmCirclesView(context);
        this.addView(this.mAmPmCirclesView);
        this.mHourRadialSelectorView = new RadialSelectorView(context);
        this.addView(this.mHourRadialSelectorView);
        this.mMinuteRadialSelectorView = new RadialSelectorView(context);
        this.addView(this.mMinuteRadialSelectorView);
        this.mSecondRadialSelectorView = new RadialSelectorView(context);
        this.addView(this.mSecondRadialSelectorView);
        this.mHourRadialTextsView = new RadialTextsView(context);
        this.addView(this.mHourRadialTextsView);
        this.mMinuteRadialTextsView = new RadialTextsView(context);
        this.addView(this.mMinuteRadialTextsView);
        this.mSecondRadialTextsView = new RadialTextsView(context);
        this.addView(this.mSecondRadialTextsView);
        this.preparePrefer30sMap();
        this.mLastValueSelected = null;
        this.mInputEnabled = true;
        this.mGrayBox = new View(context);
        this.mGrayBox.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mGrayBox.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.mdtp_transparent_black));
        this.mGrayBox.setVisibility(4);
        this.addView(this.mGrayBox);
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.mTimeInitialized = false;
    }

    public void setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    public void initialize(Context context, TimePickerController timePickerController, Timepoint initialTime, boolean is24HourMode) {
        if (this.mTimeInitialized) {
            Log.e((String)TAG, (String)"Time has already been initialized.");
            return;
        }
        this.mController = timePickerController;
        this.mIs24HourMode = this.mAccessibilityManager.isTouchExplorationEnabled() || is24HourMode;
        this.mCircleView.initialize(context, this.mController);
        this.mCircleView.invalidate();
        if (!this.mIs24HourMode && this.mController.getVersion() == TimePickerDialog.Version.VERSION_1) {
            this.mAmPmCirclesView.initialize(context, this.mController, initialTime.isAM() ? 0 : 1);
            this.mAmPmCirclesView.invalidate();
        }
        RadialTextsView.SelectionValidator secondValidator = new RadialTextsView.SelectionValidator(){

            @Override
            public boolean isValidSelection(int selection) {
                Timepoint newTime = new Timepoint(RadialPickerLayout.this.mCurrentTime.getHour(), RadialPickerLayout.this.mCurrentTime.getMinute(), selection);
                return !RadialPickerLayout.this.mController.isOutOfRange(newTime, 2);
            }
        };
        RadialTextsView.SelectionValidator minuteValidator = new RadialTextsView.SelectionValidator(){

            @Override
            public boolean isValidSelection(int selection) {
                Timepoint newTime = new Timepoint(RadialPickerLayout.this.mCurrentTime.getHour(), selection, RadialPickerLayout.this.mCurrentTime.getSecond());
                return !RadialPickerLayout.this.mController.isOutOfRange(newTime, 1);
            }
        };
        RadialTextsView.SelectionValidator hourValidator = new RadialTextsView.SelectionValidator(){

            @Override
            public boolean isValidSelection(int selection) {
                Timepoint newTime = new Timepoint(selection, RadialPickerLayout.this.mCurrentTime.getMinute(), RadialPickerLayout.this.mCurrentTime.getSecond());
                if (!RadialPickerLayout.this.mIs24HourMode && RadialPickerLayout.this.getIsCurrentlyAmOrPm() == 1) {
                    newTime.setPM();
                }
                if (!RadialPickerLayout.this.mIs24HourMode && RadialPickerLayout.this.getIsCurrentlyAmOrPm() == 0) {
                    newTime.setAM();
                }
                return !RadialPickerLayout.this.mController.isOutOfRange(newTime, 0);
            }
        };
        int[] hours = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        int[] hours_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        int[] minutes = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        int[] seconds = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        String[] hoursTexts = new String[12];
        String[] innerHoursTexts = new String[12];
        String[] minutesTexts = new String[12];
        String[] secondsTexts = new String[12];
        for (int i = 0; i < 12; ++i) {
            hoursTexts[i] = is24HourMode ? String.format(Locale.getDefault(), "%02d", hours_24[i]) : String.format(Locale.getDefault(), "%d", hours[i]);
            innerHoursTexts[i] = String.format(Locale.getDefault(), "%d", hours[i]);
            minutesTexts[i] = String.format(Locale.getDefault(), "%02d", minutes[i]);
            secondsTexts[i] = String.format(Locale.getDefault(), "%02d", seconds[i]);
        }
        this.mHourRadialTextsView.initialize(context, hoursTexts, (String[])(is24HourMode ? innerHoursTexts : null), this.mController, hourValidator, true);
        this.mHourRadialTextsView.setSelection(is24HourMode ? initialTime.getHour() : hours[initialTime.getHour() % 12]);
        this.mHourRadialTextsView.invalidate();
        this.mMinuteRadialTextsView.initialize(context, minutesTexts, null, this.mController, minuteValidator, false);
        this.mMinuteRadialTextsView.setSelection(initialTime.getMinute());
        this.mMinuteRadialTextsView.invalidate();
        this.mSecondRadialTextsView.initialize(context, secondsTexts, null, this.mController, secondValidator, false);
        this.mSecondRadialTextsView.setSelection(initialTime.getSecond());
        this.mSecondRadialTextsView.invalidate();
        this.mCurrentTime = initialTime;
        int hourDegrees = initialTime.getHour() % 12 * 30;
        this.mHourRadialSelectorView.initialize(context, this.mController, is24HourMode, true, hourDegrees, this.isHourInnerCircle(initialTime.getHour()));
        int minuteDegrees = initialTime.getMinute() * 6;
        this.mMinuteRadialSelectorView.initialize(context, this.mController, false, false, minuteDegrees, false);
        int secondDegrees = initialTime.getSecond() * 6;
        this.mSecondRadialSelectorView.initialize(context, this.mController, false, false, secondDegrees, false);
        this.mTimeInitialized = true;
    }

    public void setTime(Timepoint time) {
        this.setItem(0, time);
    }

    private void setItem(int index, Timepoint time) {
        this.mCurrentTime = time = this.roundToValidTime(time, index);
        this.reselectSelector(time, false, index);
    }

    private boolean isHourInnerCircle(int hourOfDay) {
        return this.mIs24HourMode && hourOfDay <= 12 && hourOfDay != 0;
    }

    public int getHours() {
        return this.mCurrentTime.getHour();
    }

    public int getMinutes() {
        return this.mCurrentTime.getMinute();
    }

    public int getSeconds() {
        return this.mCurrentTime.getSecond();
    }

    public Timepoint getTime() {
        return this.mCurrentTime;
    }

    private int getCurrentlyShowingValue() {
        int currentIndex = this.getCurrentItemShowing();
        switch (currentIndex) {
            case 0: {
                return this.mCurrentTime.getHour();
            }
            case 1: {
                return this.mCurrentTime.getMinute();
            }
            case 2: {
                return this.mCurrentTime.getSecond();
            }
        }
        return -1;
    }

    public int getIsCurrentlyAmOrPm() {
        if (this.mCurrentTime.isAM()) {
            return 0;
        }
        if (this.mCurrentTime.isPM()) {
            return 1;
        }
        return -1;
    }

    public void setAmOrPm(int amOrPm) {
        this.mAmPmCirclesView.setAmOrPm(amOrPm);
        this.mAmPmCirclesView.invalidate();
        Timepoint newSelection = new Timepoint(this.mCurrentTime);
        if (amOrPm == 0) {
            newSelection.setAM();
        } else if (amOrPm == 1) {
            newSelection.setPM();
        }
        newSelection = this.roundToValidTime(newSelection, 0);
        this.reselectSelector(newSelection, false, 0);
        this.mCurrentTime = newSelection;
        this.mListener.onValueSelected(newSelection);
    }

    private void preparePrefer30sMap() {
        this.mSnapPrefer30sMap = new int[361];
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            this.mSnapPrefer30sMap[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private int snapPrefer30s(int degrees) {
        if (this.mSnapPrefer30sMap == null) {
            return -1;
        }
        return this.mSnapPrefer30sMap[degrees];
    }

    private static int snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / stepSize * stepSize;
        int ceiling = floor + stepSize;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= stepSize;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    private Timepoint roundToValidTime(Timepoint newSelection, int currentItemShowing) {
        switch (currentItemShowing) {
            case 0: {
                newSelection = this.mController.roundToNearest(newSelection, Timepoint.TYPE.HOUR);
                break;
            }
            case 1: {
                newSelection = this.mController.roundToNearest(newSelection, Timepoint.TYPE.MINUTE);
                break;
            }
            case 2: {
                newSelection = this.mController.roundToNearest(newSelection, Timepoint.TYPE.SECOND);
                break;
            }
            default: {
                newSelection = this.mCurrentTime;
            }
        }
        return newSelection;
    }

    private void reselectSelector(Timepoint newSelection, boolean forceDrawDot, int index) {
        switch (index) {
            case 0: {
                int hour = newSelection.getHour();
                boolean isInnerCircle = this.isHourInnerCircle(hour);
                int degrees = hour % 12 * 360 / 12;
                if (!this.mIs24HourMode) {
                    hour %= 12;
                }
                if (!this.mIs24HourMode && hour == 0) {
                    hour += 12;
                }
                this.mHourRadialSelectorView.setSelection(degrees, isInnerCircle, forceDrawDot);
                this.mHourRadialTextsView.setSelection(hour);
                if (newSelection.getMinute() != this.mCurrentTime.getMinute()) {
                    int minDegrees = newSelection.getMinute() * 360 / 60;
                    this.mMinuteRadialSelectorView.setSelection(minDegrees, isInnerCircle, forceDrawDot);
                    this.mMinuteRadialTextsView.setSelection(newSelection.getMinute());
                }
                if (newSelection.getSecond() == this.mCurrentTime.getSecond()) break;
                int secDegrees = newSelection.getSecond() * 360 / 60;
                this.mSecondRadialSelectorView.setSelection(secDegrees, isInnerCircle, forceDrawDot);
                this.mSecondRadialTextsView.setSelection(newSelection.getSecond());
                break;
            }
            case 1: {
                int degrees = newSelection.getMinute() * 360 / 60;
                this.mMinuteRadialSelectorView.setSelection(degrees, false, forceDrawDot);
                this.mMinuteRadialTextsView.setSelection(newSelection.getMinute());
                if (newSelection.getSecond() == this.mCurrentTime.getSecond()) break;
                int secDegrees = newSelection.getSecond() * 360 / 60;
                this.mSecondRadialSelectorView.setSelection(secDegrees, false, forceDrawDot);
                this.mSecondRadialTextsView.setSelection(newSelection.getSecond());
                break;
            }
            case 2: {
                int degrees = newSelection.getSecond() * 360 / 60;
                this.mSecondRadialSelectorView.setSelection(degrees, false, forceDrawDot);
                this.mSecondRadialTextsView.setSelection(newSelection.getSecond());
            }
        }
        switch (this.getCurrentItemShowing()) {
            case 0: {
                this.mHourRadialSelectorView.invalidate();
                this.mHourRadialTextsView.invalidate();
                break;
            }
            case 1: {
                this.mMinuteRadialSelectorView.invalidate();
                this.mMinuteRadialTextsView.invalidate();
                break;
            }
            case 2: {
                this.mSecondRadialSelectorView.invalidate();
                this.mSecondRadialTextsView.invalidate();
            }
        }
    }

    private Timepoint getTimeFromDegrees(int degrees, boolean isInnerCircle, boolean forceToVisibleValue) {
        Timepoint newSelection;
        int stepSize;
        if (degrees == -1) {
            return null;
        }
        int currentShowing = this.getCurrentItemShowing();
        boolean allowFineGrained = !forceToVisibleValue && (currentShowing == 1 || currentShowing == 2);
        degrees = allowFineGrained ? this.snapPrefer30s(degrees) : RadialPickerLayout.snapOnly30s(degrees, 0);
        switch (currentShowing) {
            case 0: {
                stepSize = 30;
                break;
            }
            case 1: {
                stepSize = 6;
                break;
            }
            default: {
                stepSize = 6;
            }
        }
        if (currentShowing == 0) {
            if (this.mIs24HourMode) {
                if (degrees == 0 && isInnerCircle) {
                    degrees = 360;
                } else if (degrees == 360 && !isInnerCircle) {
                    degrees = 0;
                }
            } else if (degrees == 0) {
                degrees = 360;
            }
        } else if (degrees == 360 && (currentShowing == 1 || currentShowing == 2)) {
            degrees = 0;
        }
        int value = degrees / stepSize;
        if (currentShowing == 0 && this.mIs24HourMode && !isInnerCircle && degrees != 0) {
            value += 12;
        }
        switch (currentShowing) {
            case 0: {
                int hour = value;
                if (!this.mIs24HourMode && this.getIsCurrentlyAmOrPm() == 1 && degrees != 360) {
                    hour += 12;
                }
                if (!this.mIs24HourMode && this.getIsCurrentlyAmOrPm() == 0 && degrees == 360) {
                    hour = 0;
                }
                newSelection = new Timepoint(hour, this.mCurrentTime.getMinute(), this.mCurrentTime.getSecond());
                break;
            }
            case 1: {
                newSelection = new Timepoint(this.mCurrentTime.getHour(), value, this.mCurrentTime.getSecond());
                break;
            }
            case 2: {
                newSelection = new Timepoint(this.mCurrentTime.getHour(), this.mCurrentTime.getMinute(), value);
                break;
            }
            default: {
                newSelection = this.mCurrentTime;
            }
        }
        return newSelection;
    }

    private int getDegreesFromCoords(float pointX, float pointY, boolean forceLegal, Boolean[] isInnerCircle) {
        switch (this.getCurrentItemShowing()) {
            case 0: {
                return this.mHourRadialSelectorView.getDegreesFromCoords(pointX, pointY, forceLegal, isInnerCircle);
            }
            case 1: {
                return this.mMinuteRadialSelectorView.getDegreesFromCoords(pointX, pointY, forceLegal, isInnerCircle);
            }
            case 2: {
                return this.mSecondRadialSelectorView.getDegreesFromCoords(pointX, pointY, forceLegal, isInnerCircle);
            }
        }
        return -1;
    }

    public int getCurrentItemShowing() {
        if (this.mCurrentItemShowing != 0 && this.mCurrentItemShowing != 1 && this.mCurrentItemShowing != 2) {
            Log.e((String)TAG, (String)("Current item showing was unfortunately set to " + this.mCurrentItemShowing));
            return -1;
        }
        return this.mCurrentItemShowing;
    }

    public void setCurrentItemShowing(int index, boolean animate) {
        if (index != 0 && index != 1 && index != 2) {
            Log.e((String)TAG, (String)("TimePicker does not support view at index " + index));
            return;
        }
        int lastIndex = this.getCurrentItemShowing();
        this.mCurrentItemShowing = index;
        this.reselectSelector(this.getTime(), true, index);
        if (animate && index != lastIndex) {
            ObjectAnimator[] anims = new ObjectAnimator[4];
            if (index == 1 && lastIndex == 0) {
                anims[0] = this.mHourRadialTextsView.getDisappearAnimator();
                anims[1] = this.mHourRadialSelectorView.getDisappearAnimator();
                anims[2] = this.mMinuteRadialTextsView.getReappearAnimator();
                anims[3] = this.mMinuteRadialSelectorView.getReappearAnimator();
            } else if (index == 0 && lastIndex == 1) {
                anims[0] = this.mHourRadialTextsView.getReappearAnimator();
                anims[1] = this.mHourRadialSelectorView.getReappearAnimator();
                anims[2] = this.mMinuteRadialTextsView.getDisappearAnimator();
                anims[3] = this.mMinuteRadialSelectorView.getDisappearAnimator();
            } else if (index == 1 && lastIndex == 2) {
                anims[0] = this.mSecondRadialTextsView.getDisappearAnimator();
                anims[1] = this.mSecondRadialSelectorView.getDisappearAnimator();
                anims[2] = this.mMinuteRadialTextsView.getReappearAnimator();
                anims[3] = this.mMinuteRadialSelectorView.getReappearAnimator();
            } else if (index == 0 && lastIndex == 2) {
                anims[0] = this.mSecondRadialTextsView.getDisappearAnimator();
                anims[1] = this.mSecondRadialSelectorView.getDisappearAnimator();
                anims[2] = this.mHourRadialTextsView.getReappearAnimator();
                anims[3] = this.mHourRadialSelectorView.getReappearAnimator();
            } else if (index == 2 && lastIndex == 1) {
                anims[0] = this.mSecondRadialTextsView.getReappearAnimator();
                anims[1] = this.mSecondRadialSelectorView.getReappearAnimator();
                anims[2] = this.mMinuteRadialTextsView.getDisappearAnimator();
                anims[3] = this.mMinuteRadialSelectorView.getDisappearAnimator();
            } else if (index == 2 && lastIndex == 0) {
                anims[0] = this.mSecondRadialTextsView.getReappearAnimator();
                anims[1] = this.mSecondRadialSelectorView.getReappearAnimator();
                anims[2] = this.mHourRadialTextsView.getDisappearAnimator();
                anims[3] = this.mHourRadialSelectorView.getDisappearAnimator();
            }
            if (anims[0] != null && anims[1] != null && anims[2] != null && anims[3] != null) {
                if (this.mTransition != null && this.mTransition.isRunning()) {
                    this.mTransition.end();
                }
                this.mTransition = new AnimatorSet();
                this.mTransition.playTogether((Animator[])anims);
                this.mTransition.start();
            } else {
                this.transitionWithoutAnimation(index);
            }
        } else {
            this.transitionWithoutAnimation(index);
        }
    }

    private void transitionWithoutAnimation(int index) {
        boolean hourAlpha = index == 0;
        boolean minuteAlpha = index == 1;
        boolean secondAlpha = index == 2;
        this.mHourRadialTextsView.setAlpha((float)hourAlpha);
        this.mHourRadialSelectorView.setAlpha((float)hourAlpha);
        this.mMinuteRadialTextsView.setAlpha((float)minuteAlpha);
        this.mMinuteRadialSelectorView.setAlpha((float)minuteAlpha);
        this.mSecondRadialTextsView.setAlpha((float)secondAlpha);
        this.mSecondRadialSelectorView.setAlpha((float)secondAlpha);
    }

    public boolean onTouch(View v, MotionEvent event) {
        float eventX = event.getX();
        float eventY = event.getY();
        final Boolean[] isInnerCircle = new Boolean[]{false};
        switch (event.getAction()) {
            case 0: {
                if (!this.mInputEnabled) {
                    return true;
                }
                this.mDownX = eventX;
                this.mDownY = eventY;
                this.mLastValueSelected = null;
                this.mDoingMove = false;
                this.mDoingTouch = true;
                this.mIsTouchingAmOrPm = !this.mIs24HourMode && this.mController.getVersion() == TimePickerDialog.Version.VERSION_1 ? this.mAmPmCirclesView.getIsTouchingAmOrPm(eventX, eventY) : -1;
                if (this.mIsTouchingAmOrPm == 0 || this.mIsTouchingAmOrPm == 1) {
                    this.mController.tryVibrate();
                    this.mDownDegrees = -1;
                    this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            RadialPickerLayout.this.mAmPmCirclesView.setAmOrPmPressed(RadialPickerLayout.this.mIsTouchingAmOrPm);
                            RadialPickerLayout.this.mAmPmCirclesView.invalidate();
                        }
                    }, (long)this.TAP_TIMEOUT);
                } else {
                    boolean forceLegal = this.mAccessibilityManager.isTouchExplorationEnabled();
                    this.mDownDegrees = this.getDegreesFromCoords(eventX, eventY, forceLegal, isInnerCircle);
                    Timepoint selectedTime = this.getTimeFromDegrees(this.mDownDegrees, isInnerCircle[0], false);
                    if (this.mController.isOutOfRange(selectedTime, this.getCurrentItemShowing())) {
                        this.mDownDegrees = -1;
                    }
                    if (this.mDownDegrees != -1) {
                        this.mController.tryVibrate();
                        this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                RadialPickerLayout.this.mDoingMove = true;
                                RadialPickerLayout.this.mLastValueSelected = RadialPickerLayout.this.getTimeFromDegrees(RadialPickerLayout.this.mDownDegrees, isInnerCircle[0], false);
                                RadialPickerLayout.this.mLastValueSelected = RadialPickerLayout.this.roundToValidTime(RadialPickerLayout.this.mLastValueSelected, RadialPickerLayout.this.getCurrentItemShowing());
                                RadialPickerLayout.this.reselectSelector(RadialPickerLayout.this.mLastValueSelected, true, RadialPickerLayout.this.getCurrentItemShowing());
                                RadialPickerLayout.this.mListener.onValueSelected(RadialPickerLayout.this.mLastValueSelected);
                            }
                        }, (long)this.TAP_TIMEOUT);
                    }
                }
                return true;
            }
            case 2: {
                if (!this.mInputEnabled) {
                    Log.e((String)TAG, (String)"Input was disabled, but received ACTION_MOVE.");
                    return true;
                }
                float dY = Math.abs(eventY - this.mDownY);
                float dX = Math.abs(eventX - this.mDownX);
                if (!this.mDoingMove && dX <= (float)this.TOUCH_SLOP && dY <= (float)this.TOUCH_SLOP) break;
                if (this.mIsTouchingAmOrPm == 0 || this.mIsTouchingAmOrPm == 1) {
                    this.mHandler.removeCallbacksAndMessages(null);
                    int isTouchingAmOrPm = this.mAmPmCirclesView.getIsTouchingAmOrPm(eventX, eventY);
                    if (isTouchingAmOrPm == this.mIsTouchingAmOrPm) break;
                    this.mAmPmCirclesView.setAmOrPmPressed(-1);
                    this.mAmPmCirclesView.invalidate();
                    this.mIsTouchingAmOrPm = -1;
                    break;
                }
                if (this.mDownDegrees == -1) break;
                this.mDoingMove = true;
                this.mHandler.removeCallbacksAndMessages(null);
                int degrees = this.getDegreesFromCoords(eventX, eventY, true, isInnerCircle);
                if (degrees != -1) {
                    Timepoint value;
                    switch (this.getCurrentItemShowing()) {
                        case 0: {
                            value = this.mController.roundToNearest(this.getTimeFromDegrees(degrees, isInnerCircle[0], false), null);
                            break;
                        }
                        case 1: {
                            value = this.mController.roundToNearest(this.getTimeFromDegrees(degrees, isInnerCircle[0], false), Timepoint.TYPE.HOUR);
                            break;
                        }
                        default: {
                            value = this.mController.roundToNearest(this.getTimeFromDegrees(degrees, isInnerCircle[0], false), Timepoint.TYPE.MINUTE);
                        }
                    }
                    this.reselectSelector(value, true, this.getCurrentItemShowing());
                    if (!(value == null || this.mLastValueSelected != null && this.mLastValueSelected.equals(value))) {
                        this.mController.tryVibrate();
                        this.mLastValueSelected = value;
                        this.mListener.onValueSelected(value);
                    }
                }
                return true;
            }
            case 1: {
                int degrees;
                if (!this.mInputEnabled) {
                    Log.d((String)TAG, (String)"Input was disabled, but received ACTION_UP.");
                    this.mListener.enablePicker();
                    return true;
                }
                this.mHandler.removeCallbacksAndMessages(null);
                this.mDoingTouch = false;
                if (this.mIsTouchingAmOrPm == 0 || this.mIsTouchingAmOrPm == 1) {
                    int isTouchingAmOrPm = this.mAmPmCirclesView.getIsTouchingAmOrPm(eventX, eventY);
                    this.mAmPmCirclesView.setAmOrPmPressed(-1);
                    this.mAmPmCirclesView.invalidate();
                    if (isTouchingAmOrPm == this.mIsTouchingAmOrPm) {
                        this.mAmPmCirclesView.setAmOrPm(isTouchingAmOrPm);
                        if (this.getIsCurrentlyAmOrPm() != isTouchingAmOrPm) {
                            Timepoint newSelection = new Timepoint(this.mCurrentTime);
                            if (this.mIsTouchingAmOrPm == 0) {
                                newSelection.setAM();
                            } else if (this.mIsTouchingAmOrPm == 1) {
                                newSelection.setPM();
                            }
                            newSelection = this.roundToValidTime(newSelection, 0);
                            this.reselectSelector(newSelection, false, 0);
                            this.mCurrentTime = newSelection;
                            this.mListener.onValueSelected(newSelection);
                        }
                    }
                    this.mIsTouchingAmOrPm = -1;
                    break;
                }
                if (this.mDownDegrees != -1 && (degrees = this.getDegreesFromCoords(eventX, eventY, this.mDoingMove, isInnerCircle)) != -1) {
                    Timepoint value = this.getTimeFromDegrees(degrees, isInnerCircle[0], !this.mDoingMove);
                    value = this.roundToValidTime(value, this.getCurrentItemShowing());
                    this.reselectSelector(value, false, this.getCurrentItemShowing());
                    this.mCurrentTime = value;
                    this.mListener.onValueSelected(value);
                    this.mListener.advancePicker(this.getCurrentItemShowing());
                }
                this.mDoingMove = false;
                return true;
            }
        }
        return false;
    }

    public boolean trySettingInputEnabled(boolean inputEnabled) {
        if (this.mDoingTouch && !inputEnabled) {
            return false;
        }
        this.mInputEnabled = inputEnabled;
        this.mGrayBox.setVisibility(inputEnabled ? 4 : 0);
        return true;
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (Build.VERSION.SDK_INT >= 21) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
        } else if (Build.VERSION.SDK_INT >= 16) {
            info.addAction(4096);
            info.addAction(8192);
        } else {
            info.addAction(4096);
            info.addAction(8192);
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 32) {
            event.getText().clear();
            Calendar time = Calendar.getInstance();
            time.set(10, this.getHours());
            time.set(12, this.getMinutes());
            time.set(13, this.getSeconds());
            long millis = time.getTimeInMillis();
            int flags = 1;
            if (this.mIs24HourMode) {
                flags |= 0x80;
            }
            String timeString = DateUtils.formatDateTime((Context)this.getContext(), (long)millis, (int)flags);
            event.getText().add(timeString);
            return true;
        }
        return super.dispatchPopulateAccessibilityEvent(event);
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        int backward;
        int forward;
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        int changeMultiplier = 0;
        if (Build.VERSION.SDK_INT >= 16) {
            forward = 4096;
            backward = 8192;
        } else {
            forward = 4096;
            backward = 8192;
        }
        if (action == forward) {
            changeMultiplier = 1;
        } else if (action == backward) {
            changeMultiplier = -1;
        }
        if (changeMultiplier != 0) {
            Timepoint newSelection;
            int value = this.getCurrentlyShowingValue();
            int stepSize = 0;
            int currentItemShowing = this.getCurrentItemShowing();
            if (currentItemShowing == 0) {
                stepSize = 30;
                value %= 12;
            } else if (currentItemShowing == 1) {
                stepSize = 6;
            } else if (currentItemShowing == 2) {
                stepSize = 6;
            }
            int degrees = value * stepSize;
            degrees = RadialPickerLayout.snapOnly30s(degrees, changeMultiplier);
            value = degrees / stepSize;
            int maxValue = 0;
            int minValue = 0;
            if (currentItemShowing == 0) {
                if (this.mIs24HourMode) {
                    maxValue = 23;
                } else {
                    maxValue = 12;
                    minValue = 1;
                }
            } else {
                maxValue = 55;
            }
            if (value > maxValue) {
                value = minValue;
            } else if (value < minValue) {
                value = maxValue;
            }
            switch (currentItemShowing) {
                case 0: {
                    newSelection = new Timepoint(value, this.mCurrentTime.getMinute(), this.mCurrentTime.getSecond());
                    break;
                }
                case 1: {
                    newSelection = new Timepoint(this.mCurrentTime.getHour(), value, this.mCurrentTime.getSecond());
                    break;
                }
                case 2: {
                    newSelection = new Timepoint(this.mCurrentTime.getHour(), this.mCurrentTime.getMinute(), value);
                    break;
                }
                default: {
                    newSelection = this.mCurrentTime;
                }
            }
            this.setItem(currentItemShowing, newSelection);
            this.mListener.onValueSelected(newSelection);
            return true;
        }
        return false;
    }

    public static interface OnValueSelectedListener {
        public void onValueSelected(Timepoint var1);

        public void enablePicker();

        public void advancePicker(int var1);
    }
}

