/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import com.wdullaer.materialdatetimepicker.R;
import com.wdullaer.materialdatetimepicker.time.TimePickerController;
import com.wdullaer.materialdatetimepicker.time.TimePickerDialog;

public class RadialTextsView
extends View {
    private static final String TAG = "RadialTextsView";
    private final Paint mPaint = new Paint();
    private final Paint mSelectedPaint = new Paint();
    private final Paint mInactivePaint = new Paint();
    private boolean mDrawValuesReady;
    private boolean mIsInitialized = false;
    private int selection = -1;
    private SelectionValidator mValidator;
    private Typeface mTypefaceLight;
    private Typeface mTypefaceRegular;
    private String[] mTexts;
    private String[] mInnerTexts;
    private boolean mIs24HourMode;
    private boolean mHasInnerCircle;
    private float mCircleRadiusMultiplier;
    private float mAmPmCircleRadiusMultiplier;
    private float mNumbersRadiusMultiplier;
    private float mInnerNumbersRadiusMultiplier;
    private float mTextSizeMultiplier;
    private float mInnerTextSizeMultiplier;
    private int mXCenter;
    private int mYCenter;
    private float mCircleRadius;
    private boolean mTextGridValuesDirty;
    private float mTextSize;
    private float mInnerTextSize;
    private float[] mTextGridHeights;
    private float[] mTextGridWidths;
    private float[] mInnerTextGridHeights;
    private float[] mInnerTextGridWidths;
    private float mAnimationRadiusMultiplier;
    private float mTransitionMidRadiusMultiplier;
    private float mTransitionEndRadiusMultiplier;
    ObjectAnimator mDisappearAnimator;
    ObjectAnimator mReappearAnimator;
    private InvalidateUpdateListener mInvalidateUpdateListener;

    public RadialTextsView(Context context) {
        super(context);
    }

    public void initialize(Context context, String[] texts, String[] innerTexts, TimePickerController controller, SelectionValidator validator, boolean disappearsOut) {
        if (this.mIsInitialized) {
            Log.e((String)TAG, (String)"This RadialTextsView may only be initialized once.");
            return;
        }
        Resources res = context.getResources();
        int textColorRes = controller.isThemeDark() ? R.color.mdtp_white : R.color.mdtp_numbers_text_color;
        this.mPaint.setColor(ContextCompat.getColor((Context)context, (int)textColorRes));
        String typefaceFamily = res.getString(R.string.mdtp_radial_numbers_typeface);
        this.mTypefaceLight = Typeface.create((String)typefaceFamily, (int)0);
        String typefaceFamilyRegular = res.getString(R.string.mdtp_sans_serif);
        this.mTypefaceRegular = Typeface.create((String)typefaceFamilyRegular, (int)0);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        int selectedTextColor = ContextCompat.getColor((Context)context, (int)R.color.mdtp_white);
        this.mSelectedPaint.setColor(selectedTextColor);
        this.mSelectedPaint.setAntiAlias(true);
        this.mSelectedPaint.setTextAlign(Paint.Align.CENTER);
        int inactiveColorRes = controller.isThemeDark() ? R.color.mdtp_date_picker_text_disabled_dark_theme : R.color.mdtp_date_picker_text_disabled;
        this.mInactivePaint.setColor(ContextCompat.getColor((Context)context, (int)inactiveColorRes));
        this.mInactivePaint.setAntiAlias(true);
        this.mInactivePaint.setTextAlign(Paint.Align.CENTER);
        this.mTexts = texts;
        this.mInnerTexts = innerTexts;
        this.mIs24HourMode = controller.is24HourMode();
        boolean bl = this.mHasInnerCircle = innerTexts != null;
        if (this.mIs24HourMode || controller.getVersion() != TimePickerDialog.Version.VERSION_1) {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_circle_radius_multiplier_24HourMode));
        } else {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_circle_radius_multiplier));
            this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_ampm_circle_radius_multiplier));
        }
        this.mTextGridHeights = new float[7];
        this.mTextGridWidths = new float[7];
        if (this.mHasInnerCircle) {
            this.mNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_numbers_radius_multiplier_outer));
            this.mTextSizeMultiplier = Float.parseFloat(res.getString(R.string.mdtp_text_size_multiplier_outer));
            this.mInnerNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_numbers_radius_multiplier_inner));
            this.mInnerTextSizeMultiplier = Float.parseFloat(res.getString(R.string.mdtp_text_size_multiplier_inner));
            this.mInnerTextGridHeights = new float[7];
            this.mInnerTextGridWidths = new float[7];
        } else {
            this.mNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_numbers_radius_multiplier_normal));
            this.mTextSizeMultiplier = Float.parseFloat(res.getString(R.string.mdtp_text_size_multiplier_normal));
        }
        this.mAnimationRadiusMultiplier = 1.0f;
        this.mTransitionMidRadiusMultiplier = 1.0f + 0.05f * (float)(disappearsOut ? -1 : 1);
        this.mTransitionEndRadiusMultiplier = 1.0f + 0.3f * (float)(disappearsOut ? 1 : -1);
        this.mInvalidateUpdateListener = new InvalidateUpdateListener();
        this.mValidator = validator;
        this.mTextGridValuesDirty = true;
        this.mIsInitialized = true;
    }

    protected void setSelection(int selection) {
        this.selection = selection;
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    public void setAnimationRadiusMultiplier(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier = animationRadiusMultiplier;
        this.mTextGridValuesDirty = true;
    }

    public void onDraw(Canvas canvas) {
        int viewWidth = this.getWidth();
        if (viewWidth == 0 || !this.mIsInitialized) {
            return;
        }
        if (!this.mDrawValuesReady) {
            this.mXCenter = this.getWidth() / 2;
            this.mYCenter = this.getHeight() / 2;
            this.mCircleRadius = (float)Math.min(this.mXCenter, this.mYCenter) * this.mCircleRadiusMultiplier;
            if (!this.mIs24HourMode) {
                float amPmCircleRadius = this.mCircleRadius * this.mAmPmCircleRadiusMultiplier;
                this.mYCenter = (int)((double)this.mYCenter - (double)amPmCircleRadius * 0.75);
            }
            this.mTextSize = this.mCircleRadius * this.mTextSizeMultiplier;
            if (this.mHasInnerCircle) {
                this.mInnerTextSize = this.mCircleRadius * this.mInnerTextSizeMultiplier;
            }
            this.renderAnimations();
            this.mTextGridValuesDirty = true;
            this.mDrawValuesReady = true;
        }
        if (this.mTextGridValuesDirty) {
            float numbersRadius = this.mCircleRadius * this.mNumbersRadiusMultiplier * this.mAnimationRadiusMultiplier;
            this.calculateGridSizes(numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize, this.mTextGridHeights, this.mTextGridWidths);
            if (this.mHasInnerCircle) {
                float innerNumbersRadius = this.mCircleRadius * this.mInnerNumbersRadiusMultiplier * this.mAnimationRadiusMultiplier;
                this.calculateGridSizes(innerNumbersRadius, this.mXCenter, this.mYCenter, this.mInnerTextSize, this.mInnerTextGridHeights, this.mInnerTextGridWidths);
            }
            this.mTextGridValuesDirty = false;
        }
        this.drawTexts(canvas, this.mTextSize, this.mTypefaceLight, this.mTexts, this.mTextGridWidths, this.mTextGridHeights);
        if (this.mHasInnerCircle) {
            this.drawTexts(canvas, this.mInnerTextSize, this.mTypefaceRegular, this.mInnerTexts, this.mInnerTextGridWidths, this.mInnerTextGridHeights);
        }
    }

    private void calculateGridSizes(float numbersRadius, float xCenter, float yCenter, float textSize, float[] textGridHeights, float[] textGridWidths) {
        float offset1 = numbersRadius;
        float offset2 = numbersRadius * (float)Math.sqrt(3.0) / 2.0f;
        float offset3 = numbersRadius / 2.0f;
        this.mPaint.setTextSize(textSize);
        this.mSelectedPaint.setTextSize(textSize);
        this.mInactivePaint.setTextSize(textSize);
        textGridHeights[0] = (yCenter -= (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f) - offset1;
        textGridWidths[0] = xCenter - offset1;
        textGridHeights[1] = yCenter - offset2;
        textGridWidths[1] = xCenter - offset2;
        textGridHeights[2] = yCenter - offset3;
        textGridWidths[2] = xCenter - offset3;
        textGridHeights[3] = yCenter;
        textGridWidths[3] = xCenter;
        textGridHeights[4] = yCenter + offset3;
        textGridWidths[4] = xCenter + offset3;
        textGridHeights[5] = yCenter + offset2;
        textGridWidths[5] = xCenter + offset2;
        textGridHeights[6] = yCenter + offset1;
        textGridWidths[6] = xCenter + offset1;
    }

    private Paint[] assignTextColors(String[] texts) {
        Paint[] paints = new Paint[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            int text = Integer.parseInt(texts[i]);
            paints[i] = text == this.selection ? this.mSelectedPaint : (this.mValidator.isValidSelection(text) ? this.mPaint : this.mInactivePaint);
        }
        return paints;
    }

    private void drawTexts(Canvas canvas, float textSize, Typeface typeface, String[] texts, float[] textGridWidths, float[] textGridHeights) {
        this.mPaint.setTextSize(textSize);
        this.mPaint.setTypeface(typeface);
        Paint[] textPaints = this.assignTextColors(texts);
        canvas.drawText(texts[0], textGridWidths[3], textGridHeights[0], textPaints[0]);
        canvas.drawText(texts[1], textGridWidths[4], textGridHeights[1], textPaints[1]);
        canvas.drawText(texts[2], textGridWidths[5], textGridHeights[2], textPaints[2]);
        canvas.drawText(texts[3], textGridWidths[6], textGridHeights[3], textPaints[3]);
        canvas.drawText(texts[4], textGridWidths[5], textGridHeights[4], textPaints[4]);
        canvas.drawText(texts[5], textGridWidths[4], textGridHeights[5], textPaints[5]);
        canvas.drawText(texts[6], textGridWidths[3], textGridHeights[6], textPaints[6]);
        canvas.drawText(texts[7], textGridWidths[2], textGridHeights[5], textPaints[7]);
        canvas.drawText(texts[8], textGridWidths[1], textGridHeights[4], textPaints[8]);
        canvas.drawText(texts[9], textGridWidths[0], textGridHeights[3], textPaints[9]);
        canvas.drawText(texts[10], textGridWidths[1], textGridHeights[2], textPaints[10]);
        canvas.drawText(texts[11], textGridWidths[2], textGridHeights[1], textPaints[11]);
    }

    private void renderAnimations() {
        float midwayPoint = 0.2f;
        int duration = 500;
        Keyframe kf0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe kf1 = Keyframe.ofFloat((float)midwayPoint, (float)this.mTransitionMidRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat((float)1.0f, (float)this.mTransitionEndRadiusMultiplier);
        PropertyValuesHolder radiusDisappear = PropertyValuesHolder.ofKeyframe((String)"animationRadiusMultiplier", (Keyframe[])new Keyframe[]{kf0, kf1, kf2});
        kf0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        kf1 = Keyframe.ofFloat((float)1.0f, (float)0.0f);
        PropertyValuesHolder fadeOut = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1});
        this.mDisappearAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{radiusDisappear, fadeOut}).setDuration((long)duration);
        this.mDisappearAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mInvalidateUpdateListener);
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        midwayPoint = 1.0f - midwayPoint * (1.0f - delayPoint);
        kf0 = Keyframe.ofFloat((float)0.0f, (float)this.mTransitionEndRadiusMultiplier);
        kf1 = Keyframe.ofFloat((float)delayPoint, (float)this.mTransitionEndRadiusMultiplier);
        kf2 = Keyframe.ofFloat((float)midwayPoint, (float)this.mTransitionMidRadiusMultiplier);
        Keyframe kf3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder radiusReappear = PropertyValuesHolder.ofKeyframe((String)"animationRadiusMultiplier", (Keyframe[])new Keyframe[]{kf0, kf1, kf2, kf3});
        kf0 = Keyframe.ofFloat((float)0.0f, (float)0.0f);
        kf1 = Keyframe.ofFloat((float)delayPoint, (float)0.0f);
        kf2 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder fadeIn = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1, kf2});
        this.mReappearAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{radiusReappear, fadeIn}).setDuration((long)totalDuration);
        this.mReappearAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mInvalidateUpdateListener);
    }

    public ObjectAnimator getDisappearAnimator() {
        if (!this.mIsInitialized || !this.mDrawValuesReady || this.mDisappearAnimator == null) {
            Log.e((String)TAG, (String)"RadialTextView was not ready for animation.");
            return null;
        }
        return this.mDisappearAnimator;
    }

    public ObjectAnimator getReappearAnimator() {
        if (!this.mIsInitialized || !this.mDrawValuesReady || this.mReappearAnimator == null) {
            Log.e((String)TAG, (String)"RadialTextView was not ready for animation.");
            return null;
        }
        return this.mReappearAnimator;
    }

    static interface SelectionValidator {
        public boolean isValidSelection(int var1);
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InvalidateUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            RadialTextsView.this.invalidate();
        }
    }
}

