/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.MonthView;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class MonthAdapter
extends RecyclerView.Adapter<MonthViewHolder>
implements MonthView.OnDayClickListener {
    protected final DatePickerController mController;
    private CalendarDay mSelectedDay;
    protected static int WEEK_7_OVERHANG_HEIGHT = 7;
    protected static final int MONTHS_IN_YEAR = 12;

    public MonthAdapter(DatePickerController controller) {
        this.mController = controller;
        this.init();
        this.setSelectedDay(this.mController.getSelectedDay());
        this.setHasStableIds(true);
    }

    public void setSelectedDay(CalendarDay day) {
        this.mSelectedDay = day;
        this.notifyDataSetChanged();
    }

    public CalendarDay getSelectedDay() {
        return this.mSelectedDay;
    }

    protected void init() {
        this.mSelectedDay = new CalendarDay(System.currentTimeMillis(), this.mController.getTimeZone());
    }

    public MonthViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        MonthView v = this.createMonthView(parent.getContext());
        AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
        v.setLayoutParams((ViewGroup.LayoutParams)params);
        v.setClickable(true);
        v.setOnDayClickListener(this);
        return new MonthViewHolder(v);
    }

    public void onBindViewHolder(MonthViewHolder holder, int position) {
        holder.bind(position, this.mController, this.mSelectedDay);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        Calendar endDate = this.mController.getEndDate();
        Calendar startDate = this.mController.getStartDate();
        int endMonth = endDate.get(1) * 12 + endDate.get(2);
        int startMonth = startDate.get(1) * 12 + startDate.get(2);
        return endMonth - startMonth + 1;
    }

    public abstract MonthView createMonthView(Context var1);

    @Override
    public void onDayClick(MonthView view, CalendarDay day) {
        if (day != null) {
            this.onDayTapped(day);
        }
    }

    protected void onDayTapped(CalendarDay day) {
        this.mController.tryVibrate();
        this.mController.onDayOfMonthSelected(day.year, day.month, day.day);
        this.setSelectedDay(day);
    }

    static class MonthViewHolder
    extends RecyclerView.ViewHolder {
        public MonthViewHolder(MonthView itemView) {
            super((View)itemView);
        }

        void bind(int position, DatePickerController mController, CalendarDay selectedCalendarDay) {
            int month = (position + mController.getStartDate().get(2)) % 12;
            int year = (position + mController.getStartDate().get(2)) / 12 + mController.getMinYear();
            int selectedDay = -1;
            if (this.isSelectedDayInMonth(selectedCalendarDay, year, month)) {
                selectedDay = selectedCalendarDay.day;
            }
            ((MonthView)this.itemView).setMonthParams(selectedDay, year, month, mController.getFirstDayOfWeek());
            this.itemView.invalidate();
        }

        private boolean isSelectedDayInMonth(CalendarDay selectedDay, int year, int month) {
            return selectedDay.year == year && selectedDay.month == month;
        }
    }

    public static class CalendarDay {
        private Calendar calendar;
        int year;
        int month;
        int day;
        TimeZone mTimeZone;

        public CalendarDay(TimeZone timeZone) {
            this.mTimeZone = timeZone;
            this.setTime(System.currentTimeMillis());
        }

        public CalendarDay(long timeInMillis, TimeZone timeZone) {
            this.mTimeZone = timeZone;
            this.setTime(timeInMillis);
        }

        public CalendarDay(Calendar calendar, TimeZone timeZone) {
            this.mTimeZone = timeZone;
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.day = calendar.get(5);
        }

        public CalendarDay(int year, int month, int day) {
            this.setDay(year, month, day);
        }

        public CalendarDay(int year, int month, int day, TimeZone timezone) {
            this.mTimeZone = timezone;
            this.setDay(year, month, day);
        }

        public void set(CalendarDay date) {
            this.year = date.year;
            this.month = date.month;
            this.day = date.day;
        }

        public void setDay(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        private void setTime(long timeInMillis) {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance(this.mTimeZone);
            }
            this.calendar.setTimeInMillis(timeInMillis);
            this.month = this.calendar.get(2);
            this.year = this.calendar.get(1);
            this.day = this.calendar.get(5);
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }
    }
}

