/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker;

import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;

public class GravitySnapHelper
extends LinearSnapHelper {
    private OrientationHelper verticalHelper;
    private OrientationHelper horizontalHelper;
    private int gravity;
    private boolean isRtlHorizontal;
    private SnapListener listener;
    private boolean snapping;
    private RecyclerView.OnScrollListener mScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (newState == 2) {
                GravitySnapHelper.this.snapping = false;
            }
            if (newState == 0 && GravitySnapHelper.this.listener != null) {
                int position = GravitySnapHelper.this.getSnappedPosition(recyclerView);
                if (position != -1) {
                    GravitySnapHelper.this.listener.onSnap(position);
                }
                GravitySnapHelper.this.snapping = false;
            }
        }
    };

    public GravitySnapHelper(int gravity) {
        this(gravity, null);
    }

    public GravitySnapHelper(int gravity, SnapListener snapListener) {
        if (gravity != 0x800003 && gravity != 0x800005 && gravity != 80 && gravity != 48) {
            throw new IllegalArgumentException("Invalid gravity value. Use START | END | BOTTOM | TOP constants");
        }
        this.gravity = gravity;
        this.listener = snapListener;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (recyclerView != null) {
            if ((this.gravity == 0x800003 || this.gravity == 0x800005) && Build.VERSION.SDK_INT >= 17) {
                boolean bl = this.isRtlHorizontal = recyclerView.getContext().getResources().getConfiguration().getLayoutDirection() == 1;
            }
            if (this.listener != null) {
                recyclerView.addOnScrollListener(this.mScrollListener);
            }
        }
        super.attachToRecyclerView(recyclerView);
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        out[0] = layoutManager.canScrollHorizontally() ? (this.gravity == 0x800003 ? this.distanceToStart(targetView, this.getHorizontalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getHorizontalHelper(layoutManager), false)) : 0;
        out[1] = layoutManager.canScrollVertically() ? (this.gravity == 48 ? this.distanceToStart(targetView, this.getVerticalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getVerticalHelper(layoutManager), false)) : 0;
        return out;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        View snapView = null;
        if (layoutManager instanceof LinearLayoutManager) {
            switch (this.gravity) {
                case 0x800003: {
                    snapView = this.findStartView(layoutManager, this.getHorizontalHelper(layoutManager));
                    break;
                }
                case 0x800005: {
                    snapView = this.findEndView(layoutManager, this.getHorizontalHelper(layoutManager));
                    break;
                }
                case 48: {
                    snapView = this.findStartView(layoutManager, this.getVerticalHelper(layoutManager));
                    break;
                }
                case 80: {
                    snapView = this.findEndView(layoutManager, this.getVerticalHelper(layoutManager));
                }
            }
        }
        this.snapping = snapView != null;
        return snapView;
    }

    private int distanceToStart(View targetView, OrientationHelper helper, boolean fromEnd) {
        if (this.isRtlHorizontal && !fromEnd) {
            return this.distanceToEnd(targetView, helper, true);
        }
        return helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
    }

    private int distanceToEnd(View targetView, OrientationHelper helper, boolean fromStart) {
        if (this.isRtlHorizontal && !fromStart) {
            return this.distanceToStart(targetView, helper, true);
        }
        return helper.getDecoratedEnd(targetView) - helper.getEndAfterPadding();
    }

    private View findStartView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean endOfList;
            int firstChild = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            if (firstChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(firstChild);
            float visibleWidth = this.isRtlHorizontal ? (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child) : (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child);
            boolean bl = endOfList = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            if (visibleWidth > 0.5f && !endOfList) {
                return child;
            }
            if (endOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(firstChild + 1);
        }
        return null;
    }

    private View findEndView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean startOfList;
            int lastChild = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            if (lastChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(lastChild);
            float visibleWidth = this.isRtlHorizontal ? (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child) : (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child);
            boolean bl = startOfList = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() == 0;
            if (visibleWidth > 0.5f && !startOfList) {
                return child;
            }
            if (startOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(lastChild - 1);
        }
        return null;
    }

    private int getSnappedPosition(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            if (this.gravity == 0x800003 || this.gravity == 48) {
                return ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
            }
            if (this.gravity == 0x800005 || this.gravity == 80) {
                return ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
            }
        }
        return -1;
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.verticalHelper == null) {
            this.verticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.verticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.horizontalHelper == null) {
            this.horizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.horizontalHelper;
    }

    public static interface SnapListener {
        public void onSnap(int var1);
    }
}

