/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mockito.internal.util.JavaEightUtil;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.mock.MockName;
import org.mockito.stubbing.Answer;

public class ReturnsEmptyValues
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 1998191268711234347L;

    @Override
    public Object answer(InvocationOnMock invocation) {
        if (ObjectMethodsGuru.isToStringMethod(invocation.getMethod())) {
            Object mock = invocation.getMock();
            MockName name = MockUtil.getMockName(mock);
            if (name.isDefault()) {
                return "Mock for " + MockUtil.getMockSettings(mock).getTypeToMock().getSimpleName() + ", hashCode: " + mock.hashCode();
            }
            return name.toString();
        }
        if (ObjectMethodsGuru.isCompareToMethod(invocation.getMethod())) {
            return invocation.getMock() == invocation.getArgument(0) ? 0 : 1;
        }
        Class<?> returnType = invocation.getMethod().getReturnType();
        return this.returnValueFor(returnType);
    }

    Object returnValueFor(Class<?> type2) {
        if (Primitives.isPrimitiveOrWrapper(type2)) {
            return Primitives.defaultValue(type2);
        }
        if (type2 == Iterable.class) {
            return new ArrayList(0);
        }
        if (type2 == Collection.class) {
            return new LinkedList();
        }
        if (type2 == Set.class) {
            return new HashSet();
        }
        if (type2 == HashSet.class) {
            return new HashSet();
        }
        if (type2 == SortedSet.class) {
            return new TreeSet();
        }
        if (type2 == TreeSet.class) {
            return new TreeSet();
        }
        if (type2 == LinkedHashSet.class) {
            return new LinkedHashSet();
        }
        if (type2 == List.class) {
            return new LinkedList();
        }
        if (type2 == LinkedList.class) {
            return new LinkedList();
        }
        if (type2 == ArrayList.class) {
            return new ArrayList();
        }
        if (type2 == Map.class) {
            return new HashMap();
        }
        if (type2 == HashMap.class) {
            return new HashMap();
        }
        if (type2 == SortedMap.class) {
            return new TreeMap();
        }
        if (type2 == TreeMap.class) {
            return new TreeMap();
        }
        if (type2 == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if ("java.util.Optional".equals(type2.getName())) {
            return JavaEightUtil.emptyOptional();
        }
        if ("java.util.OptionalDouble".equals(type2.getName())) {
            return JavaEightUtil.emptyOptionalDouble();
        }
        if ("java.util.OptionalInt".equals(type2.getName())) {
            return JavaEightUtil.emptyOptionalInt();
        }
        if ("java.util.OptionalLong".equals(type2.getName())) {
            return JavaEightUtil.emptyOptionalLong();
        }
        if ("java.util.stream.Stream".equals(type2.getName())) {
            return JavaEightUtil.emptyStream();
        }
        if ("java.util.stream.DoubleStream".equals(type2.getName())) {
            return JavaEightUtil.emptyDoubleStream();
        }
        if ("java.util.stream.IntStream".equals(type2.getName())) {
            return JavaEightUtil.emptyIntStream();
        }
        if ("java.util.stream.LongStream".equals(type2.getName())) {
            return JavaEightUtil.emptyLongStream();
        }
        return null;
    }
}

