/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.DeepDifference;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;

public class ShouldBeEqualByComparingFieldByFieldRecursively
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeEqualByComparingFieldByFieldRecursive(Object actual, Object other, List<DeepDifference.Difference> differences, Representation representation) {
        ArrayList<String> descriptionOfDifferences = new ArrayList<String>(differences.size());
        for (DeepDifference.Difference difference : differences) {
            descriptionOfDifferences.add(ShouldBeEqualByComparingFieldByFieldRecursively.describeDifference(difference, representation));
        }
        return new ShouldBeEqualByComparingFieldByFieldRecursively("%nExpecting:%n  <%s>%nto be equal to:%n  <%s>%nwhen recursively comparing field by field, but found the following difference(s):%n" + Strings.join(descriptionOfDifferences).with(String.format("%n", new Object[0])), actual, other);
    }

    private ShouldBeEqualByComparingFieldByFieldRecursively(String message, Object actual, Object other) {
        super(message, actual, other);
    }

    private static String describeDifference(DeepDifference.Difference difference, Representation representation) {
        String otherFieldValue;
        String actualFieldValue = representation.toStringOf(difference.getActual());
        boolean sameRepresentation = Objects.areEqual(actualFieldValue, otherFieldValue = representation.toStringOf(difference.getOther()));
        String actualFieldValueRepresentation = sameRepresentation ? representation.unambiguousToStringOf(difference.getActual()) : actualFieldValue;
        String otherFieldValueRepresentation = sameRepresentation ? representation.unambiguousToStringOf(difference.getOther()) : otherFieldValue;
        return String.format("%nPath to difference: <%s>%n- expected: <%s>%n- actual  : <%s>", Strings.join(difference.getPath()).with("."), otherFieldValueRepresentation, actualFieldValueRepresentation);
    }
}

