/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import org.mockito.internal.invocation.finder.AllInvocationsFinder;
import org.mockito.internal.junit.UnusedStubbings;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.invocation.Invocation;
import org.mockito.stubbing.Stubbing;

public class UnusedStubbingsFinder {
    public UnusedStubbings getUnusedStubbings(Iterable<Object> mocks) {
        Set<Stubbing> stubbings = AllInvocationsFinder.findStubbings(mocks);
        LinkedList<Stubbing> unused = ListUtil.filter(stubbings, new ListUtil.Filter<Stubbing>(){

            @Override
            public boolean isOut(Stubbing s2) {
                return s2.wasUsed();
            }
        });
        return new UnusedStubbings(unused);
    }

    public Collection<Invocation> getUnusedStubbingsByLocation(Iterable<Object> mocks) {
        Set<Stubbing> stubbings = AllInvocationsFinder.findStubbings(mocks);
        HashSet<String> locationsOfUsedStubbings = new HashSet<String>();
        for (Stubbing s2 : stubbings) {
            if (!s2.wasUsed()) continue;
            String location = s2.getInvocation().getLocation().toString();
            locationsOfUsedStubbings.add(location);
        }
        LinkedHashMap<String, Invocation> out = new LinkedHashMap<String, Invocation>();
        for (Stubbing s3 : stubbings) {
            String location = s3.getInvocation().getLocation().toString();
            if (locationsOfUsedStubbings.contains(location)) continue;
            out.put(location, s3.getInvocation());
        }
        return out.values();
    }
}

