/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;

public class ShouldHaveCause
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveCause(Throwable actualCause, Throwable expectedCause) {
        Preconditions.checkArgument(expectedCause != null, "expected cause should not be null", new Object[0]);
        if (actualCause == null) {
            return new ShouldHaveCause(expectedCause);
        }
        if (Objects.areEqual(actualCause.getMessage(), expectedCause.getMessage())) {
            return new ShouldHaveCause(actualCause, expectedCause.getClass());
        }
        if (Objects.areEqual(actualCause.getClass(), expectedCause.getClass())) {
            return new ShouldHaveCause(actualCause, expectedCause.getMessage());
        }
        return new ShouldHaveCause(actualCause, expectedCause);
    }

    private ShouldHaveCause(Throwable actualCause, Throwable expectedCause) {
        super("%nExpecting a cause with type:%n  <%s>%nand message:%n  <%s>%nbut type was:%n  <%s>%nand message was:%n  <%s>.", expectedCause.getClass().getName(), expectedCause.getMessage(), actualCause.getClass().getName(), actualCause.getMessage());
    }

    private ShouldHaveCause(Throwable expectedCause) {
        super("%nExpecting a cause with type:%n  <%s>%nand message:%n  <%s>%nbut actualCause had no cause.", expectedCause.getClass().getName(), expectedCause.getMessage());
    }

    private ShouldHaveCause(Throwable actualCause, Class<? extends Throwable> expectedCauseClass) {
        super("%nExpecting a cause with type:%n  <%s>%nbut type was:%n  <%s>.", expectedCauseClass.getName(), actualCause.getClass().getName());
    }

    private ShouldHaveCause(Throwable actualCause, String expectedCauseMessage) {
        super("%nExpecting a cause with message:%n  <%s>%nbut message was:%n  <%s>.", expectedCauseMessage, actualCause.getMessage());
    }
}

