/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.description.Description;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.DoubleComparator;
import org.assertj.core.util.FloatComparator;

public abstract class AbstractObjectAssert<SELF extends AbstractObjectAssert<SELF, ACTUAL>, ACTUAL>
extends AbstractAssert<SELF, ACTUAL> {
    private static final double DOUBLE_COMPARATOR_PRECISION = 1.0E-15;
    private static final float FLOAT_COMPARATOR_PRECISION = 1.0E-6f;
    private Map<String, Comparator<?>> comparatorByPropertyOrField = new HashMap();
    private TypeComparators comparatorByType = AbstractObjectAssert.defaultTypeComparators();

    public AbstractObjectAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public static TypeComparators defaultTypeComparators() {
        TypeComparators comparatorByType = new TypeComparators();
        comparatorByType.put(Double.class, new DoubleComparator(1.0E-15));
        comparatorByType.put(Float.class, new FloatComparator(1.0E-6f));
        return comparatorByType;
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description) {
        return (SELF)((AbstractObjectAssert)super.as(description));
    }

    @Override
    @CheckReturnValue
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractObjectAssert)super.as(description, args));
    }

    public SELF isEqualToIgnoringNullFields(Object other) {
        this.objects.assertIsEqualToIgnoringNullFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF isEqualToComparingOnlyGivenFields(Object other, String ... propertiesOrFieldsUsedInComparison) {
        this.objects.assertIsEqualToComparingOnlyGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType, propertiesOrFieldsUsedInComparison);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF isEqualToIgnoringGivenFields(Object other, String ... propertiesOrFieldsToIgnore) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType, propertiesOrFieldsToIgnore);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasNoNullFieldsOrProperties() {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, new String[0]);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasNoNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, propertiesOrFieldsToIgnore);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF isEqualToComparingFieldByField(Object other) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType, new String[0]);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForFields(Comparator<T> comparator, String ... propertiesOrFields) {
        for (String propertyOrField : propertiesOrFields) {
            this.comparatorByPropertyOrField.put(propertyOrField, comparator);
        }
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForType(Comparator<T> comparator, Class<T> type2) {
        this.comparatorByType.put(type2, comparator);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasFieldOrProperty(String name) {
        this.objects.assertHasFieldOrProperty(this.info, this.actual, name);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasFieldOrPropertyWithValue(String name, Object value) {
        this.objects.assertHasFieldOrPropertyWithValue(this.info, this.actual, name, value);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @CheckReturnValue
    public AbstractObjectArrayAssert<?, Object> extracting(String ... propertiesOrFields) {
        Tuple values = Extractors.byName(propertiesOrFields).extract(this.actual);
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return new ObjectArrayAssert<Object>(values.toArray()).as(description, new Object[0]);
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractObjectArrayAssert<?, Object> extracting(Function<? super ACTUAL, Object> ... extractors) {
        Object[] values = Stream.of(extractors).map(extractor -> extractor.apply(this.actual)).toArray();
        return new ObjectArrayAssert<Object>(values);
    }

    public SELF isEqualToComparingFieldByFieldRecursively(Object other) {
        this.objects.assertIsEqualToComparingFieldByFieldRecursively(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public <T> SELF returns(T expected, Function<ACTUAL, T> from) {
        Objects.requireNonNull(from, "The given getter method/Function must not be null");
        this.objects.assertEqual(this.info, from.apply(this.actual), expected);
        return (SELF)((AbstractObjectAssert)this.myself);
    }
}

