/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mockito.internal.configuration.injection.ConstructorInjection;
import org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.mockito.internal.configuration.injection.PropertyAndSetterInjection;
import org.mockito.internal.configuration.injection.SpyOnInjectedFieldsHandler;
import org.mockito.internal.util.Checks;
import org.mockito.internal.util.collections.Sets;

public class MockInjection {
    public static OngoingMockInjection onField(Field field2, Object ofInstance) {
        return new OngoingMockInjection(field2, ofInstance);
    }

    public static OngoingMockInjection onFields(Set<Field> fields, Object ofInstance) {
        return new OngoingMockInjection(fields, ofInstance);
    }

    public static class OngoingMockInjection {
        private final Set<Field> fields = new HashSet<Field>();
        private final Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        private final Object fieldOwner;
        private final MockInjectionStrategy injectionStrategies = MockInjectionStrategy.nop();
        private final MockInjectionStrategy postInjectionStrategies = MockInjectionStrategy.nop();

        private OngoingMockInjection(Field field2, Object fieldOwner) {
            this(Collections.singleton(field2), fieldOwner);
        }

        private OngoingMockInjection(Set<Field> fields, Object fieldOwner) {
            this.fieldOwner = Checks.checkNotNull(fieldOwner, "fieldOwner");
            this.fields.addAll((Collection<Field>)Checks.checkItemsNotNull(fields, "fields"));
        }

        public OngoingMockInjection withMocks(Set<Object> mocks) {
            this.mocks.addAll((Collection<Object>)Checks.checkNotNull(mocks, "mocks"));
            return this;
        }

        public OngoingMockInjection tryConstructorInjection() {
            this.injectionStrategies.thenTry(new ConstructorInjection());
            return this;
        }

        public OngoingMockInjection tryPropertyOrFieldInjection() {
            this.injectionStrategies.thenTry(new PropertyAndSetterInjection());
            return this;
        }

        public OngoingMockInjection handleSpyAnnotation() {
            this.postInjectionStrategies.thenTry(new SpyOnInjectedFieldsHandler());
            return this;
        }

        public void apply() {
            for (Field field2 : this.fields) {
                this.injectionStrategies.process(field2, this.fieldOwner, this.mocks);
                this.postInjectionStrategies.process(field2, this.fieldOwner, this.mocks);
            }
        }
    }
}

