/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.mockito.Mockito;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.listeners.StubbingLookupListener;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MatchableInvocation;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Stubbing;

class DefaultStubbingLookupListener
implements StubbingLookupListener {
    private Strictness currentStrictness;
    private boolean mismatchesReported;

    DefaultStubbingLookupListener(Strictness strictness) {
        this.currentStrictness = strictness;
    }

    @Override
    public void onStubbingLookup(Invocation invocation, MatchableInvocation stubbingFound) {
        if (this.currentStrictness != Strictness.STRICT_STUBS) {
            return;
        }
        if (stubbingFound == null) {
            List<Invocation> argMismatchStubbings = DefaultStubbingLookupListener.potentialArgMismatches(invocation);
            if (!argMismatchStubbings.isEmpty()) {
                this.mismatchesReported = true;
                Reporter.potentialStubbingProblem(invocation, argMismatchStubbings);
            }
        } else {
            invocation.markVerified();
        }
    }

    private static List<Invocation> potentialArgMismatches(Invocation invocation) {
        LinkedList<Invocation> matchingStubbings = new LinkedList<Invocation>();
        Collection<Stubbing> stubbings = Mockito.mockingDetails(invocation.getMock()).getStubbings();
        for (Stubbing s2 : stubbings) {
            if (s2.wasUsed() || !s2.getInvocation().getMethod().getName().equals(invocation.getMethod().getName())) continue;
            matchingStubbings.add(s2.getInvocation());
        }
        return matchingStubbings;
    }

    void setCurrentStrictness(Strictness currentStrictness) {
        this.currentStrictness = currentStrictness;
    }

    boolean isMismatchesReported() {
        return this.mismatchesReported;
    }
}

