/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.reflect.Method;
import java.util.LinkedList;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.powermock.core.testlisteners.GlobalNotificationBuildSupport;
import org.powermock.modules.junit4.internal.impl.NotificationBuilder;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.PowerMockTestNotifier;

class PowerMockRunNotifier
extends RunNotifier
implements GlobalNotificationBuildSupport.Callback {
    private Class<?> suiteClass = null;
    private final Thread motherThread = Thread.currentThread();
    private final RunNotifier junitRunNotifier;
    private final PowerMockTestNotifier powerMockTestNotifier;
    private final Method[] testMethods;
    private final LinkedList<Object> pendingTestInstancesOnMotherThread = new LinkedList();
    private final ThreadLocal<NotificationBuilder> notificationBuilder = new ThreadLocal<NotificationBuilder>(){

        @Override
        protected NotificationBuilder initialValue() {
            return new NotificationBuilder((Method[])PowerMockRunNotifier.this.testMethods.clone(), PowerMockRunNotifier.this.powerMockTestNotifier, PowerMockRunNotifier.this.pendingTestInstancesOnMotherThread);
        }
    };

    PowerMockRunNotifier(RunNotifier junitRunNotifier, PowerMockTestNotifier powerMockTestNotifier, Method[] testMethods) {
        this.junitRunNotifier = junitRunNotifier;
        this.powerMockTestNotifier = powerMockTestNotifier;
        this.testMethods = testMethods;
    }

    Class<?> getSuiteClass() {
        return this.suiteClass;
    }

    @Override
    public void suiteClassInitiated(Class<?> testClass) {
        this.suiteClass = testClass;
        this.notificationBuilder.get().testSuiteStarted(testClass);
    }

    @Override
    public void testInstanceCreated(Object testInstance) {
        if (Thread.currentThread() == this.motherThread) {
            this.pendingTestInstancesOnMotherThread.add(testInstance);
        }
        this.notificationBuilder.get().testInstanceCreated(testInstance);
    }

    @Override
    public void addListener(RunListener listener) {
        this.invoke("addListener", listener);
    }

    @Override
    public void removeListener(RunListener listener) {
        this.invoke("removeListener", listener);
    }

    @Override
    public void fireTestRunStarted(Description description) {
        this.invoke("fireTestRunStarted", description);
    }

    @Override
    public void fireTestRunFinished(Result result) {
        this.invoke("fireTestRunFinished", result);
    }

    @Override
    public void fireTestStarted(Description description) throws StoppedByUserException {
        this.invoke("fireTestStarted", description);
        this.notificationBuilder.get().testStartHasBeenFired(description);
    }

    @Override
    public void fireTestFailure(Failure failure) {
        this.notificationBuilder.get().failure(failure);
        this.invoke("fireTestFailure", failure);
    }

    @Override
    public void fireTestAssumptionFailed(Failure failure) {
        this.notificationBuilder.get().assumptionFailed(failure.getDescription());
        this.invoke("fireTestAssumptionFailed", failure);
    }

    @Override
    public void fireTestIgnored(Description description) {
        this.notificationBuilder.get().testIgnored(description);
        this.invoke("fireTestIgnored", description);
    }

    @Override
    public void fireTestFinished(Description description) {
        try {
            this.notificationBuilder.get().testFinished(description);
        }
        catch (Throwable failure) {
            this.fireTestFailure(new Failure(description, failure));
            return;
        }
        this.invoke("fireTestFinished", description);
    }

    @Override
    public void pleaseStop() {
        this.invoke("pleaseStop", new Object[0]);
    }

    @Override
    public void addFirstListener(RunListener listener) {
        this.invoke("addFirstListener", listener);
    }

    private void invoke(String methodName, Object ... args) {
        try {
            Whitebox.invokeMethod((Object)this.junitRunNotifier, methodName, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

