/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.impl.ClassMockTransformer;
import org.powermock.core.transformers.impl.InterfaceMockTransformer;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;

class MockClassLoaderFactory {
    private final String[] packagesToIgnore;
    private final Class<?> testClass;
    private final String[] classesToLoadByMockClassloader;
    private final MockTransformer[] extraMockTransformers;

    public MockClassLoaderFactory(Class<?> testClass, String[] classesToLoadByMockClassloader, String[] packagesToIgnore, MockTransformer ... extraMockTransformers) {
        this.testClass = testClass;
        this.classesToLoadByMockClassloader = classesToLoadByMockClassloader;
        this.packagesToIgnore = packagesToIgnore;
        this.extraMockTransformers = extraMockTransformers;
    }

    public ClassLoader create() {
        String[] classesToLoadByMockClassloader = this.makeSureArrayContainsTestClassName(this.classesToLoadByMockClassloader, this.testClass.getName());
        ClassLoader mockLoader = this.isContextClassLoaderShouldBeUsed(classesToLoadByMockClassloader) ? Thread.currentThread().getContextClassLoader() : this.createMockClassLoader(classesToLoadByMockClassloader);
        return mockLoader;
    }

    protected ClassLoader createMockClassLoader(final String[] classesToLoadByMockClassloader) {
        List<MockTransformer> mockTransformerChain = this.getMockTransformers(this.extraMockTransformers);
        final UseClassPathAdjuster useClassPathAdjuster = this.testClass.getAnnotation(UseClassPathAdjuster.class);
        ClassLoader mockLoader = AccessController.doPrivileged(new PrivilegedAction<MockClassLoader>(){

            @Override
            public MockClassLoader run() {
                return new MockClassLoader(classesToLoadByMockClassloader, MockClassLoaderFactory.this.packagesToIgnore, useClassPathAdjuster);
            }
        });
        MockClassLoader mockClassLoader = (MockClassLoader)mockLoader;
        mockClassLoader.setMockTransformerChain(mockTransformerChain);
        new MockPolicyInitializerImpl(this.testClass).initialize(mockLoader);
        return mockLoader;
    }

    protected boolean isContextClassLoaderShouldBeUsed(String[] classesToLoadByMockClassloader) {
        return (classesToLoadByMockClassloader == null || classesToLoadByMockClassloader.length == 0) && !this.hasMockPolicyProvidedClasses(this.testClass);
    }

    protected List<MockTransformer> getMockTransformers(MockTransformer[] extraMockTransformers) {
        ArrayList<MockTransformer> mockTransformerChain = new ArrayList<MockTransformer>();
        mockTransformerChain.add(new ClassMockTransformer());
        mockTransformerChain.add(new InterfaceMockTransformer());
        Collections.addAll(mockTransformerChain, extraMockTransformers);
        return mockTransformerChain;
    }

    private String[] makeSureArrayContainsTestClassName(String[] arrayOfClassNames, String testClassName) {
        if (null == arrayOfClassNames || 0 == arrayOfClassNames.length) {
            return new String[]{testClassName};
        }
        ArrayList<String> modifiedArrayOfClassNames = new ArrayList<String>(arrayOfClassNames.length + 1);
        modifiedArrayOfClassNames.add(testClassName);
        for (String className : arrayOfClassNames) {
            if (testClassName.equals(className)) {
                return arrayOfClassNames;
            }
            modifiedArrayOfClassNames.add(className);
        }
        return modifiedArrayOfClassNames.toArray(new String[arrayOfClassNames.length + 1]);
    }

    protected boolean hasMockPolicyProvidedClasses(Class<?> testClass) {
        boolean hasMockPolicyProvidedClasses = false;
        if (testClass.isAnnotationPresent(MockPolicy.class)) {
            MockPolicy annotation = testClass.getAnnotation(MockPolicy.class);
            Class<? extends PowerMockPolicy>[] value = annotation.value();
            hasMockPolicyProvidedClasses = new MockPolicyInitializerImpl(value).needsInitialization();
        }
        return hasMockPolicyProvidedClasses;
    }
}

