/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.mockpolicies.support;

import java.lang.reflect.Method;
import org.powermock.reflect.Whitebox;

public class LogPolicySupport {
    public Method[] getLoggerMethods(String fullyQualifiedClassName, String methodName, String logFramework) {
        try {
            return Whitebox.getMethods(this.getType(fullyQualifiedClassName, logFramework), methodName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getType(String name, String logFramework) throws Exception {
        Class<?> loggerType;
        try {
            loggerType = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Cannot find %s in the classpath which the %s policy requires.", logFramework, this.getClass().getSimpleName());
            throw new RuntimeException(message, e);
        }
        return loggerType;
    }
}

