/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.domain.plugin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xebialabs.agatha.domain.plugin.PluginManifestEntity;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class PluginCustomField
implements PluginManifestEntity {
    @JsonProperty(value="title", required=true)
    private Title title;
    @JsonIgnore
    private Type type;

    public Title getTitle() {
        return this.title;
    }

    public PluginCustomField setTitle(Title title2) {
        this.title = title2;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public PluginCustomField setType(Type type2) {
        this.type = type2;
        return this;
    }

    @JsonProperty(value="type")
    public String getTypeForJson() {
        return this.type.getName();
    }

    @JsonProperty(value="type")
    public void setTypeForJson(String value) {
        this.type = Type.fromName(value);
    }

    public String toString() {
        return "PluginCustomField{title=" + this.title + ", type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginCustomField that = (PluginCustomField)o;
        return Objects.equals(this.title, that.title) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.type);
    }

    public static class Title
    implements PluginManifestEntity {
        @JsonProperty(required=true)
        private String displayName;

        public String getDisplayName() {
            return this.displayName;
        }

        public Title setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public String toString() {
            return "Title{displayName='" + this.displayName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Title title2 = (Title)o;
            return Objects.equals(this.displayName, title2.displayName);
        }

        public int hashCode() {
            return Objects.hash(this.displayName);
        }
    }

    public static enum Type implements Serializable
    {
        STRING_NOT_ANALYZED("stringNotAnalyzed"),
        DOUBLE("double"),
        LONG("long"),
        MULTI_SELECT("multiSelect");

        private static Map<String, Type> byName;
        private String name;

        public static Type fromName(String name) {
            return byName.get(name);
        }

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            ConcurrentHashMap<String, Type> map = new ConcurrentHashMap<String, Type>();
            for (Type type2 : Type.values()) {
                map.put(type2.getName(), type2);
            }
            byName = Collections.unmodifiableMap(map);
        }
    }
}

