/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.configuration;

import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;

public class PowerMockitoSpyAnnotationEngine
extends SpyAnnotationEngine {
    @Override
    public void process(Class<?> context, Object testClass) {
        Field[] fields;
        for (Field field2 : fields = context.getDeclaredFields()) {
            if (!field2.isAnnotationPresent(Spy.class)) continue;
            try {
                Whitebox.invokeMethod((Object)this, Spy.class, field2, new Class[]{Mock.class, Mock.class, Captor.class});
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            boolean wasAccessible = field2.isAccessible();
            field2.setAccessible(true);
            try {
                Object instance = field2.get(testClass);
                if (instance == null) {
                    throw new MockitoException("Cannot create a @Spy for '" + field2.getName() + "' field because the *instance* is missing\nExample of correct usage of @Spy:\n   @Spy List mock = new LinkedList();\n");
                }
                field2.set(testClass, PowerMockito.spy(instance));
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems initiating spied field " + field2.getName(), e);
            }
            finally {
                field2.setAccessible(wasAccessible);
            }
        }
    }
}

