/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import org.powermock.api.mockito.expectation.reporter.MockitoPowerMockReporter;
import org.powermock.api.mockito.internal.mockcreation.MockTypeValidator;
import org.powermock.core.agent.JavaAgentClassRegister;
import org.powermock.core.classloader.PowerMockModified;
import org.powermock.core.reporter.PowerMockReporter;

public class MockTypeValidatorFactory {
    public static <T> MockTypeValidator<T> createValidator(Class<T> type2, boolean isStatic, boolean isSpy, JavaAgentClassRegister agentClassRegister) {
        if (!isStatic || isSpy || MockTypeValidatorFactory.isLoadedByBootstrap(type2)) {
            return new NullMockTypeValidator();
        }
        if (agentClassRegister == null) {
            return new DefaultMockTypeValidator<T>(type2);
        }
        return new JavaAgentMockTypeValidator(type2, agentClassRegister);
    }

    private static boolean isLoadedByBootstrap(Class type2) {
        return type2.getClassLoader() == null;
    }

    private static class NullMockTypeValidator<T>
    implements MockTypeValidator<T> {
        private NullMockTypeValidator() {
        }

        @Override
        public void validate() {
        }
    }

    private static abstract class AbstractMockTypeValidator<T>
    implements MockTypeValidator<T> {
        final PowerMockReporter reporter;
        final Class<T> type;

        private AbstractMockTypeValidator(Class<T> type2) {
            this.type = type2;
            this.reporter = new MockitoPowerMockReporter();
        }

        @Override
        public abstract void validate();
    }

    private static class JavaAgentMockTypeValidator<T>
    extends AbstractMockTypeValidator<T> {
        private final JavaAgentClassRegister agentClassRegister;

        private JavaAgentMockTypeValidator(Class<T> type2, JavaAgentClassRegister agentClassRegister) {
            super(type2);
            this.agentClassRegister = agentClassRegister;
        }

        @Override
        public void validate() {
            if (!this.isModifiedByAgent()) {
                this.reporter.classNotPrepared(this.type);
            }
        }

        private boolean isModifiedByAgent() {
            return this.agentClassRegister.isModifiedByAgent(this.type.getClassLoader(), this.type.getName());
        }
    }

    private static class DefaultMockTypeValidator<T>
    extends AbstractMockTypeValidator<T> {
        DefaultMockTypeValidator(Class<T> type2) {
            super(type2);
        }

        @Override
        public void validate() {
            if (!this.isModifiedByPowerMock()) {
                this.reporter.classNotPrepared(this.type);
            }
        }

        private boolean isModifiedByPowerMock() {
            return PowerMockModified.class.isAssignableFrom(this.type);
        }
    }
}

