/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.application.jaas;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class CrowdGroup
implements Group,
Serializable {
    private static final long serialVersionUID = 8957329341484952072L;
    private final Set members = new HashSet();
    private final String name;

    public CrowdGroup(String name) {
        this.name = name;
    }

    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    public boolean isMember(Principal member) {
        if (this.members.contains(member)) {
            return true;
        }
        for (Principal memberItem : this.members) {
            if (!(memberItem instanceof Group) || !((Group)memberItem).isMember(member)) continue;
            return true;
        }
        return false;
    }

    public Enumeration members() {
        return Collections.enumeration(this.members);
    }

    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        return this.membersEquals(other);
    }

    private boolean membersEquals(Group other) {
        Enumeration otherMembers = other.members();
        if (otherMembers == null) {
            return false;
        }
        HashSet copyOfMembers = new HashSet(this.members);
        while (otherMembers.hasMoreElements()) {
            Principal otherMember = (Principal)otherMembers.nextElement();
            boolean myMembersContainedOtherMember = copyOfMembers.remove(otherMember);
            if (myMembersContainedOtherMember) continue;
            return false;
        }
        return copyOfMembers.isEmpty();
    }

    public String toString() {
        return this.getName();
    }
}

