/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.application.jaas;

import com.atlassian.crowd.application.jaas.UserRolesLoginModule;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.login.LoginException;

public class CrowdLoginModule
extends UserRolesLoginModule {
    private boolean storeToken = false;
    private boolean useToken = false;
    private String applicationName;
    private SecurityServerClient securityServerClient;

    @Override
    public void preInitialise(Map options) {
        Properties properties = this.loadCrowdProperties();
        this.log.debug((Object)("crowd.properties: " + properties));
        this.log.debug((Object)("Module Options: " + options));
        properties.putAll((Map<?, ?>)options);
        this.log.debug((Object)("Final Combined Options: " + properties));
        this.useToken = "true".equalsIgnoreCase((String)options.get("useToken"));
        this.storeToken = this.useToken || "true".equalsIgnoreCase((String)options.get("storeToken"));
        long start = System.currentTimeMillis();
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)SoapClientPropertiesImpl.newInstanceFromProperties((Properties)properties));
        long stop = System.currentTimeMillis();
        System.out.println(Thread.currentThread() + "\t(stop-start) = " + (stop - start));
        this.applicationName = properties.getProperty("application.name");
        super.preInitialise(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadCrowdProperties() {
        Properties properties = new Properties();
        InputStream crowdPropertiesResource = null;
        try {
            crowdPropertiesResource = Thread.currentThread().getContextClassLoader().getResourceAsStream("crowd.properties");
            if (crowdPropertiesResource != null) {
                properties.load(crowdPropertiesResource);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (crowdPropertiesResource != null) {
                try {
                    crowdPropertiesResource.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    @Override
    protected Set authenticate(Map credentials) throws LoginException {
        String token;
        String user = (String)credentials.get("javax.security.auth.login.name");
        char[] pass = (char[])credentials.get("javax.security.auth.login.password");
        if (pass == null) {
            throw new LoginException("Password not supplied.");
        }
        if (!this.useToken && user == null) {
            throw new LoginException("User not supplied.");
        }
        if (this.useToken) {
            token = new String(pass);
            try {
                SOAPPrincipal SOAPPrincipal2 = this.securityServerClient.findPrincipalByToken(token);
                user = SOAPPrincipal2.getName();
            }
            catch (RemoteException e) {
                this.log.debug((Object)e);
                throw new LoginException("Unable to authorise with remote server.");
            }
            catch (Exception e) {
                this.log.debug((Object)e);
                throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
            }
            catch (Throwable e) {
                this.log.error((Object)e);
                throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        UserAuthenticationContext context = new UserAuthenticationContext();
        context.setName(user);
        context.setApplication(this.applicationName);
        PasswordCredential passwordCredential = new PasswordCredential(new String(pass), this.storeToken);
        context.setCredential(passwordCredential);
        long start = System.currentTimeMillis();
        try {
            token = this.securityServerClient.authenticatePrincipal(context);
        }
        catch (RemoteException e) {
            this.log.debug((Object)e);
            throw new LoginException("Unable to authorise with remote server.");
        }
        catch (Exception e) {
            this.log.debug((Object)e);
            throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
        }
        catch (Throwable e) {
            this.log.error((Object)e);
            throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            long stop = System.currentTimeMillis();
            System.out.println(Thread.currentThread() + "\tauthenticatePrincipal " + (stop - start));
        }
        try {
            String[] groups = this.securityServerClient.findGroupMemberships(user);
            HashSet<String> roles = new HashSet<String>();
            for (int i = 0; i < groups.length; ++i) {
                String role = groups[i];
                roles.add(role);
            }
            if (this.storeToken) {
                credentials.put("javax.security.auth.login.password", token.toCharArray());
            }
            return this.createPrincipals(user, roles);
        }
        catch (RemoteException e) {
            this.log.debug((Object)e);
            throw new LoginException("Unable to authorise with remote server.");
        }
        catch (Exception e) {
            this.log.debug((Object)e);
            throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
        }
        catch (Throwable e) {
            this.log.error((Object)e);
            throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

