package com.xebialabs.deployit.plugin.apache.httpd.mapper;

import static com.google.common.base.Preconditions.checkNotNull;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.StaticContent;
import com.xebialabs.deployit.ci.artifact.mapping.StaticContentMapping;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;

public class StaticContentToApacheHttpdServerMapper extends StepGeneratingMapper<StaticContent, StaticContentMapping, ApacheHttpdServer> {

	public StaticContentToApacheHttpdServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(StaticContent newSource, StaticContentMapping newMapping, ApacheHttpdServer newTarget, List<Step> steps) {
		String vhost = checkNotNull(newMapping.getVirtualHost(), "No virtual host supplied");
		steps.add(new CopyStep(Host.getLocalHost(), newSource.getLocation(), newTarget.getHost(), newTarget.getHtdocsDirPathForVirtualHost(vhost), true));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(StaticContent oldSource, StaticContentMapping oldMapping, ApacheHttpdServer oldTarget, List<Step> steps) {
		String vhost = checkNotNull(oldMapping.getVirtualHost(), "No virtual host supplied");
		steps.add(new DeleteStep(oldTarget.getHost(), oldTarget.getHtdocsDirPathForVirtualHost(vhost)));
	}

	@Override
	public void setDefaults(Deployment d, StaticContentMapping m) {
		m.setVirtualHost(d.getVhostDefinition());
	}

}
