package com.xebialabs.deployit.plugin.apache.httpd.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;

@SuppressWarnings("serial")
public class DestroyApacheHttpdVirtualHostStep extends AbstractApacheHttpdServerStep {

	private String virtualHost;

	public DestroyApacheHttpdVirtualHostStep(ApacheHttpdServer apacheWebServer, String vhostDefinition) {
		super(apacheWebServer);
		virtualHost = vhostDefinition;
		setDescription("Destroy Apache HTTP Server virtual host " + virtualHost + " in Apache HTTP server " + apacheWebServer + " on host "
				+ apacheWebServer.getHost());
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = apacheHttpdServer.connectToAdminHost();
		try {
			String configFilePath = apacheHttpdServer.getConfFilePathForVirtualHost(virtualHost);
			ctx.logOutput("Deleting virtualhost config file " + configFilePath);
			HostFile configFile = hostSession.getFile(configFilePath);
			configFile.delete();

			String htdocsDirPath = apacheHttpdServer.getHtdocsDirPathForVirtualHost(virtualHost);
			ctx.logOutput("Deleting htdocs directory " + htdocsDirPath);
			HostFile htdocsDir = hostSession.getFile(htdocsDirPath);
			htdocsDir.deleteRecursively();

			return true;
		} finally {
			hostSession.close();
		}
	}

}
