package com.xebialabs.deployit.plugin.apache.httpd.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;

@SuppressWarnings("serial")
public class RestartApacheHttpdServerStep extends AbstractApacheHttpdServerStep {

	public RestartApacheHttpdServerStep(ApacheHttpdServer apache) {
		super(apache);
		setDescription("Restart Apache HTTP Server " + apache + " on " + apache.getHost());
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hs = apacheHttpdServer.connectToAdminHost();
		try {
			CommandExecutionCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
			int res = hs.execute(handler, apacheHttpdServer.getApachectlPath(), "-k", "restart");
			return res == 0;
		} finally {
			hs.close();
		}
	}
}
