/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.httpd.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.HttpdServer;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.apache.httpd.step.ApacheVirtualHostDefinition;
import java.util.Collections;

@ConfigurationItem(description="A standard Apache 2 installation.", category="middleware")
public class ApacheHttpdServer
extends HttpdServer {
    @ConfigurationItemProperty(required=true, label="Apache Control Path", description="The path of the executable that will restart apache. Valid examples; /usr/sbin/apachectl")
    private String apachectlPath;
    @ConfigurationItemProperty(required=true, description="The location where deployit will generate apache httpd.conf fragment files.")
    private String configurationLocation;
    @ConfigurationItemProperty(required=true, label=" Ht Docs Location", description="The location where deployit will create a directory (based on the vhost name) where static content will be placed.")
    private String htdocsLocation;
    @ConfigurationItemProperty(required=true, description="The location where deployit will create a directory where access log will be placed.")
    private String accessLogLocation;
    @ConfigurationItemProperty(required=true, description="The location where deployit will create a directory where error log will be placed.")
    private String errorLogLocation;

    public HostSession connectToAdminHost() {
        return HostSessionFactory.getHostSession((Host)this.host);
    }

    public ApacheVirtualHostDefinition getVhostDefinition(String virtualHost) {
        return new ApacheVirtualHostDefinition(virtualHost, this.htdocsLocation, this.host.getOperatingSystemFamily(), Collections.singleton(this));
    }

    public String getConfFilePathForVirtualHost(String virtualHost) {
        StringBuilder confFilePath = new StringBuilder();
        confFilePath.append(this.getConfigurationLocation());
        confFilePath.append(this.getHost().getFileSeparator());
        confFilePath.append(this.getVhostDefinition(virtualHost).getFileName());
        return confFilePath.toString();
    }

    public String getHtdocsDirPathForVirtualHost(String virtualHost) {
        return this.getVhostDefinition(virtualHost).getDocumentRoot();
    }

    public String getApachectlPath() {
        return this.apachectlPath;
    }

    public void setApachectlPath(String apachectlPath) {
        this.apachectlPath = apachectlPath;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public String getHtdocsLocation() {
        return this.htdocsLocation;
    }

    public void setHtdocsLocation(String htdocsLocation) {
        this.htdocsLocation = htdocsLocation;
    }

    public String getAccessLogLocation() {
        return this.accessLogLocation;
    }

    public void setAccessLogLocation(String accessLogLocation) {
        this.accessLogLocation = accessLogLocation;
    }

    public String getErrorLogLocation() {
        return this.errorLogLocation;
    }

    public void setErrorLogLocation(String errorLogLocation) {
        this.errorLogLocation = errorLogLocation;
    }
}

