package com.xebialabs.deployit.plugin.apache.modjk.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.step.RestartApacheHttpdServerStep;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfiguration;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfigurationMapping;
import com.xebialabs.deployit.plugin.apache.modjk.step.CreateModkJKConfigFileStep;
import com.xebialabs.deployit.plugin.apache.modjk.step.DeleteModkJKConfigFileStep;

import java.util.List;

public class ModJkApacheModuleConfigurationToApacheHttpdServerMapper
		extends StepGeneratingMapper<ModJkApacheModuleConfiguration, ModJkApacheModuleConfigurationMapping, ApacheHttpdServer> {

	public ModJkApacheModuleConfigurationToApacheHttpdServerMapper(Change<Deployment> change) {
		super(change, false);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(ModJkApacheModuleConfiguration newMappingSource, ModJkApacheModuleConfigurationMapping newMapping, ApacheHttpdServer newMappingTarget, List<Step> steps) {
		steps.add(new CreateModkJKConfigFileStep(newMappingTarget, newMappingSource, newMapping));
		steps.add(new RestartApacheHttpdServerStep(newMappingTarget));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(ModJkApacheModuleConfiguration oldMappingSource, ModJkApacheModuleConfigurationMapping oldVersionOfModifiedMapping, ApacheHttpdServer oldMappingTarget, List<Step> steps) {
		steps.add(new DeleteModkJKConfigFileStep(oldMappingTarget, oldMappingSource, oldVersionOfModifiedMapping));
		steps.add(new RestartApacheHttpdServerStep(oldMappingTarget));
	}
}
