package com.xebialabs.deployit.plugin.apache.modjk.step;


import com.xebialabs.deployit.util.ExtendedStringUtils;
import org.apache.commons.collections.Transformer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class LoadBalancer implements Serializable {

	private final String name;
	private final Set<Worker> workers = new HashSet<Worker>();
	private final Set<String> workerNames = new HashSet<String>();
	private int stickySession = 1;

	public LoadBalancer(String name, Set<Worker> workers) {
		this.name = name;
		this.workers.addAll(workers);
	}

	public LoadBalancer(String name, Properties properties) {
		this.name = name;
		//String bw = getProperty("balance_workers", properties);
		String bw = properties.getProperty("worker." + name + "." + "balance_workers", "");
		for (String w : bw.split(","))
			workerNames.add(w);

		stickySession = Integer.parseInt(properties.getProperty("worker." + name + ".sticky_session", "1"));
	}

	public void addWorker(Worker w) {
		if (workerNames.contains(w.getName()))
			workers.add(w);
	}

	public Set<Worker> getWorkers() {
		return Collections.unmodifiableSet(workers);
	}

	public int getStickySession() {
		return stickySession;
	}

	public void setStickySession(int stickySession) {
		this.stickySession = stickySession;
	}

	public String getWorkerNames() {
		return ExtendedStringUtils.join(workers, new Transformer() {
			public String transform(Object obj) {
				Worker worker = (Worker) obj;
				if (worker == null)
					return "XXX";
				return worker.getName();
			}
		});

	}

	public String getName() {
		return name;
	}


	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (!(o instanceof LoadBalancer)) return false;

		LoadBalancer that = (LoadBalancer) o;

		if (name != null ? !name.equals(that.name) : that.name != null) return false;

		return true;
	}

	@Override
	public int hashCode() {
		return name != null ? name.hashCode() : 0;
	}
}
