package com.xebialabs.deployit.core.rest.resteasy;

import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;

import static com.xebialabs.deployit.core.rest.resteasy.Workdir.Clean.*;

@Component
@Provider
public class WorkdirInjectorFactory extends InjectorFactoryImpl {

    @Override
    public MethodInjector createMethodInjector(final ResourceLocator method, final ResteasyProviderFactory factory) {
        return new WorkdirMethodInjector(method, factory);
    }

    public static class WorkdirMethodInjector extends MethodInjectorImpl {

        private final ResourceLocator resourceLocator;

        public WorkdirMethodInjector(ResourceLocator resourceLocator, ResteasyProviderFactory factory) {
            super(resourceLocator, factory);
            this.resourceLocator = resourceLocator;
        }

        @Override
        public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException, WebApplicationException {
            Workdir.Clean clean = null;
            try {
                Method realMethod = AopUtils.getTargetClass(resource).getMethod(method.getMethod().getName(), resourceLocator.getMethod().getParameterTypes());
                if (realMethod.isAnnotationPresent(Workdir.class)) {
                    Workdir workdirAnnotation = realMethod.getAnnotation(Workdir.class);
                    String prefix = workdirAnnotation.prefix();
                    clean = workdirAnnotation.clean();
                    logger.trace("Initializing WorkDir for method [{}] with prefix [{}]", method, prefix);
                    WorkdirHolder.initWorkdir(prefix);
                }
            } catch (NoSuchMethodException ignored) {}
            try {
                return super.invoke(request, httpResponse, resource);
            } catch (RuntimeException e) {
                if (clean == ONLY_ON_EXCEPTION) {
                    WorkdirHolder.get().delete();
                }
                throw e;
            } finally {
                if (clean == ALWAYS) {
                    WorkdirHolder.get().delete();
                }
                WorkdirHolder.clear();
            }
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(WorkdirInjectorFactory.class);
}
