package com.xebialabs.deployit.core.rest.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.Permission;

import static java.util.stream.Collectors.toList;

public class MetadataServiceImpl implements MetadataService {

    @Override
    public List<Descriptor> listDescriptors() {
        return listAllNonVirtual();
    }

    @Override
    public Map<String, Set<String>> inheritance() {
        return MetadataServiceUtil.inheritanceMap(listAllNonVirtual());
    }

    private List<Descriptor> listAllNonVirtual() {
        return DescriptorRegistry.getDescriptors().stream().filter(input -> !input.isVirtual()).collect(toList());
    }

    @Override
    public Descriptor findDescriptor(Type type) {
        return DescriptorRegistry.getDescriptor(type);
    }

    @Override
    public List<com.xebialabs.deployit.engine.api.security.Permission> listPermissions() {
        return DtoWriter.writeReferenceDataPermissions(Permission.getAll());
    }

    @Override
    public List<String> listOrchestrators() {
        return new ArrayList<>();
    }
}
