package com.xebialabs.deployit;

import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/**
 */
public class ServerLaunchOptions {

    @Option(name="-setup", usage = "(Re-)run the setup")
    private boolean doSetup = false;

    @Option(name="-reinitialize", usage = "Reinitialize the repository, only useful with -setup")
    private boolean reinitialize = false;

    @Option(name="-force")
    private boolean force;

    @Option(name="-force-upgrades", usage = "Force execution of upgrades at startup")
    private boolean forceUpgrades;

    @Option(name="-setup-defaults", usage = "Use the given file for defaults during setup (e.g. use " +
            "`-setup-defaults conf/poc-setup.properties` to run with in-memory database (NB! In-memory database NOT recommended for production)).")
    private String defaultsFile;

    @Option(name="-repository-keystore-password", usage = "The password to open the repository-keystore.jceks file, if not given, the server will prompt you.")
    private String repositoryKeystorePassword;

    @Option(name = "-help", usage = "Prints this usage message")
    private boolean printUsage = false;

    @Option(name = "-previous-installation", usage = "Path to previous XL Deploy installation to copy the configuration from")
    private String previousInstallation;

    @Option(name = "-external-config", usage = "Enable external configuration")
    private Boolean externalConfig;

    private static volatile ServerLaunchOptions instance;

    public boolean isDoSetup() {
        return doSetup;
    }

    public void setDoSetup(final boolean doSetup) {
        this.doSetup = doSetup;
    }

    public boolean isReinitialize() {
        return reinitialize;
    }

    public void setReinitialize(final boolean reinitialize) {
        this.reinitialize = reinitialize;
    }

    public boolean isForce() {
        return force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isForceUpgrades() {
        return forceUpgrades;
    }

    public void setForceUpgrades(boolean forceUpgrades) {
        this.forceUpgrades = forceUpgrades;
    }

    public boolean isPrintUsage() {
        return printUsage;
    }

    public void setPrintUsage(boolean printUsage) {
        this.printUsage = printUsage;
    }

    public String getDefaultsFile() {
        return defaultsFile;
    }

    public void setDefaultsFile(String defaultsFile) {
        this.defaultsFile = defaultsFile;
    }

    public String getRepositoryKeystorePassword() {
        return repositoryKeystorePassword;
    }

    public void setRepositoryKeystorePassword(final String repositoryKeystorePassword) {
        this.repositoryKeystorePassword = repositoryKeystorePassword;
    }

    public void setPreviousInstallation(final String previousInstallation) {
        this.previousInstallation = previousInstallation;
    }

    public String getPreviousInstallation() {
        return previousInstallation;
    }

    public Boolean isExternalConfig() {
        return externalConfig;
    }

    public void setExternalConfig(final Boolean externalConfig) {
        this.externalConfig = externalConfig;
    }

    public static ServerLaunchOptions parseCommandLine(String[] args) {
        ServerLaunchOptions options = new ServerLaunchOptions();
        final CmdLineParser parser = new CmdLineParser(options);
        try {
            parser.parseArgument(args);
            if (options.isPrintUsage()) {
                printUsage(parser, System.out);
                return null;
            }
        } catch (CmdLineException e) {
            System.err.println(e.getMessage());
            printUsage(parser, System.err);
            return null;
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser, PrintStream stream) {
        stream.println("Supported options:");
        parser.printUsage(stream);
    }

    public static ServerLaunchOptions getInstance() {
        return instance;
    }

    public static void setInstance(ServerLaunchOptions launchOptions) {
        ServerLaunchOptions.instance = launchOptions;
    }

}
