package com.xebialabs.license.filter;

import org.apache.http.HttpStatus;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.Arrays;


public class LicenseRegistrationCheckFilter extends LicenseCheckFilter {

    private static final String ALLOWED_URL = "/deployit/server/license/reload";

    private boolean isAcceptedHtml(HttpServletRequest httpRequest) {
        String headerValue = httpRequest.getHeader(HttpHeaders.ACCEPT);
        return headerValue != null && Arrays.asList(headerValue.split(",")).contains(MediaType.TEXT_HTML);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        HttpServletResponse httpResponse = (HttpServletResponse) response;
        String registerUrl = "/register";

        String uri = httpRequest.getRequestURI();
        boolean isDummy = licenseService.getLicense().isDummyLicense();
        boolean isRegisterBased = uri.startsWith(registerUrl);

        if (uri.equals(ALLOWED_URL)) {
            super.doFilter(request, response, chain);
            return;
        }

        if (!isDummy && isRegisterBased) {
            httpResponse.sendRedirect("/");
            return;
        }

        if (isDummy && !isRegisterBased) {
            if (!isAcceptedHtml(httpRequest)) {
                // In case of connecting from not the browser we need
                httpResponse.setStatus(HttpStatus.SC_FORBIDDEN);
            } else {
                httpResponse.sendRedirect(registerUrl);
            }
            return;
        }

        super.doFilter(request, response, chain);
    }
}
