package com.xebialabs.license.filter;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.license.service.LicenseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static javax.servlet.http.HttpServletResponse.SC_PAYMENT_REQUIRED;

public class LicenseCheckFilter implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LicenseCheckFilter.class);

    protected LicenseService licenseService;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        log.trace("Added LicenseCheckFilter to the mix.");

        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(filterConfig.getServletContext());
        Checks.checkNotNull(ctx, "LicenseCheckFilter: Could not find web application context");

        licenseService = ctx.getBean(LicenseService.class);
        Checks.checkNotNull(licenseService, "LicenseCheckFilter: Could not find license check service");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (licenseService.isLicenseExpired() && response instanceof HttpServletResponse) {
            HttpServletResponse hsr = (HttpServletResponse) response;
            hsr.sendError(SC_PAYMENT_REQUIRED, "License expired");
        } else {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
        // Empty
    }
}
