package com.xebialabs.deployit.jetty;

import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.LicenseService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

import static java.nio.charset.StandardCharsets.UTF_8;

@Deprecated
public class DownloadLicenseServlet extends HttpServlet {

    private File license;
    private String product;

    private CloseableHttpClient client = HttpClientBuilder.create().build();

    @Autowired
    private LicenseService licenseService;

    @Autowired
    private String downloadLicenseServer;

    private static final Logger logger = LoggerFactory.getLogger(DownloadLicenseServlet.class);

    public DownloadLicenseServlet(File license, String product) {
        this.license = license;
        this.product = product;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext(this, config.getServletContext());
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            copyLicenceToTheServer(request);
            licenseService.reload();
        } catch (LicenseViolationException e) {
            FileUtils.deleteQuietly(license);
            logger.error(e.getMessage(), e);
            System.exit(1);
        } catch (JSONException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private HttpPost createDownloadUrl(HttpServletRequest request) throws IOException, JSONException {
        String registrationData = IOUtils.toString(request.getInputStream(), UTF_8);
        JSONObject inputJson = new JSONObject(registrationData);
        String url = MessageFormat.format("{0}api/license/{1}/free", getDownloadServerUrl(), product);

        return submitRegistrationData(url, inputJson);
    }

    private String getDownloadServerUrl() {
        String systemServerUrl = System.getenv("DOWNLOAD_LICENSE_SERVER_URL");
        if (StringUtils.isNotBlank(systemServerUrl)) {
            if (!systemServerUrl.endsWith("/")) {
                systemServerUrl = systemServerUrl + "/";
            }

            return systemServerUrl;
        }
        return downloadLicenseServer;
    }

    private void copyLicenceToTheServer(HttpServletRequest request) throws IOException, JSONException {
        HttpRequestBase httpRequest = createDownloadUrl(request);
        HttpEntity licenceLinkJson = call(httpRequest);

        JSONObject json = new JSONObject(IOUtils.toString(licenceLinkJson.getContent(), UTF_8));
        String licenseLink = json.getString("link");

        HttpGet httpGetLicense = new HttpGet(licenseLink);
        HttpEntity licence = call(httpGetLicense);
        FileUtils.copyInputStreamToFile(licence.getContent(), license);
    }

    private HttpPost submitRegistrationData(String url, JSONObject json) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader(new BasicHeader(HTTP.CONTENT_TYPE, "application/json"));
        httpPost.setEntity(new StringEntity(json.toString(), UTF_8));
        return httpPost;
    }

    private HttpEntity call(HttpRequestBase request) throws IOException {
        HttpResponse httpResponse = client.execute(request);
        return httpResponse.getEntity();
    }
}
