package com.xebialabs.deployit.jetty;

import jakarta.servlet.ServletContextEvent;
import org.eclipse.jetty.util.MultiException;
import org.jboss.resteasy.plugins.spring.SpringContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class DeployitSpringContextLoaderListener extends SpringContextLoaderListener {
    private static MultiException ex = new MultiException();

    private static WebApplicationContext webApplicationContext = null;

    @Override
    public void contextInitialized(ServletContextEvent event) {
        try {
            super.contextInitialized(event);
            webApplicationContext = (WebApplicationContext) event.getServletContext()
                    .getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        } catch (RuntimeException | Error re) {
            ex.add(re);
            throw re;
        }
    }

    public static void checkCorrectlyInitialized() {
        ex.ifExceptionThrowRuntime();
    }

    public static WebApplicationContext getWebApplicationContext() {
        return webApplicationContext;
    }
}
