package com.xebialabs.deployit;

import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

import java.io.IOException;
import java.io.Writer;

/**
 * Interface to describe specific handlers for specific error conditions.
 */
public interface HttpErrorHandler {

    /**
     * Can this implementation handle the type of error raised for the request?
     */
    boolean canHandle(Request request, int code);

    /**
     * Write the content of the HTML page to display.
     */
    void writeErrorContent(Writer writer) throws IOException;

    /**
     * Enables a specific handler to change the response.
     */
    default void changeResponse(Response response) {
    };
}
